/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.cluster.ClusterEvent;
import com.liferay.portal.kernel.cluster.ClusterEventListener;
import com.liferay.portal.kernel.cluster.ClusterEventType;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.executor.PortalExecutorManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.messaging.proxy.MessageValuesThreadLocal;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.lucene.FieldWeightSimilarity;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.IndexAccessorImpl;
import com.liferay.portal.search.lucene.LikeKeywordAnalyzer;
import com.liferay.portal.search.lucene.LuceneHelper;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.LuceneIndexer;
import com.liferay.portal.search.lucene.PerFieldAnalyzer;
import com.liferay.portal.search.lucene.SynchronizedIndexAccessorImpl;
import com.liferay.portal.search.lucene.cluster.LuceneClusterUtil;
import com.liferay.portal.search.lucene.highlight.QueryTermExtractor;
import com.liferay.portal.security.auth.TransientTokenUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.StopWatch;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class LuceneHelperImpl
implements LuceneHelper {
    private static final long _CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT = PropsValues.CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT;
    private static final int _LUCENE_BOOLEAN_QUERY_CLAUSE_MAX_SIZE = GetterUtil.getInteger((String)PropsUtil.get("lucene.boolean.query.clause.max.size"), (int)BooleanQuery.getMaxClauseCount());
    private static final String[] _KEYWORDS_LOWERCASE = new String[]{" and ", " not ", " or "};
    private static final String[] _KEYWORDS_UPPERCASE = new String[]{" AND ", " NOT ", " OR "};
    private static Log _log = LogFactoryUtil.getLog(LuceneHelperImpl.class);
    private static MethodKey _createTokenMethodKey = new MethodKey(TransientTokenUtil.class, "createToken", new Class[]{Long.TYPE});
    private static MethodKey _getLastGenerationMethodKey = new MethodKey(LuceneHelperUtil.class, "getLastGeneration", new Class[]{Long.TYPE});
    private Analyzer _analyzer;
    private Map<Long, IndexAccessor> _indexAccessors = new ConcurrentHashMap<Long, IndexAccessor>();
    private LoadIndexClusterEventListener _loadIndexClusterEventListener;
    private ThreadPoolExecutor _luceneIndexThreadPoolExecutor;
    private Version _version;

    @Override
    public void addDocument(long companyId, Document document) throws IOException {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        indexAccessor.addDocument(document);
    }

    @Override
    public void addExactTerm(BooleanQuery booleanQuery, String field, String value) {
        this.addTerm(booleanQuery, field, value, false);
    }

    @Override
    public void addNumericRangeTerm(BooleanQuery booleanQuery, String field, Integer startValue, Integer endValue) {
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newIntRange((String)field, (Integer)startValue, (Integer)endValue, (boolean)true, (boolean)true);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.SHOULD);
    }

    @Override
    public void addNumericRangeTerm(BooleanQuery booleanQuery, String field, Long startValue, Long endValue) {
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)field, (Long)startValue, (Long)endValue, (boolean)true, (boolean)true);
        booleanQuery.add((Query)numericRangeQuery, BooleanClause.Occur.SHOULD);
    }

    @Override
    public void addNumericRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        this.addNumericRangeTerm(booleanQuery, field, GetterUtil.getLong((String)startValue), GetterUtil.getLong((String)endValue));
    }

    @Override
    public void addRangeTerm(BooleanQuery booleanQuery, String field, String startValue, String endValue) {
        boolean includesLower = true;
        if (startValue != null && startValue.equals("*")) {
            includesLower = false;
        }
        boolean includesUpper = true;
        if (endValue != null && endValue.equals("*")) {
            includesUpper = false;
        }
        TermRangeQuery termRangeQuery = new TermRangeQuery(field, startValue, endValue, includesLower, includesUpper);
        booleanQuery.add((Query)termRangeQuery, BooleanClause.Occur.SHOULD);
    }

    @Override
    public void addRequiredTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        this.addRequiredTerm(booleanQuery, field, new String[]{value}, like);
    }

    @Override
    public void addRequiredTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        if (values == null) {
            return;
        }
        BooleanQuery query = new BooleanQuery();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.addTerm(query, field, value, like);
            ++n2;
        }
        booleanQuery.add((Query)query, BooleanClause.Occur.MUST);
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like) {
        this.addTerm(booleanQuery, field, value, like, BooleanClauseOccur.SHOULD);
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String value, boolean like, BooleanClauseOccur booleanClauseOccur) {
        block5: {
            PerFieldAnalyzer perFieldAnalyzer;
            Analyzer fieldAnalyzer;
            if (Validator.isNull((String)value)) {
                return;
            }
            Analyzer analyzer = this.getAnalyzer();
            if (analyzer instanceof PerFieldAnalyzer && (fieldAnalyzer = (perFieldAnalyzer = (PerFieldAnalyzer)analyzer).getAnalyzer(field)) instanceof LikeKeywordAnalyzer) {
                like = true;
            }
            if (like) {
                value = StringUtil.replace((String)value, (String)"%", (String)"");
            }
            try {
                QueryParser queryParser = new QueryParser(this.getVersion(), field, analyzer);
                value = StringUtil.replace((String)value, (String[])_KEYWORDS_LOWERCASE, (String[])_KEYWORDS_UPPERCASE);
                Query query = queryParser.parse(value);
                BooleanClause.Occur occur = null;
                occur = booleanClauseOccur.equals(BooleanClauseOccur.MUST) ? BooleanClause.Occur.MUST : (booleanClauseOccur.equals(BooleanClauseOccur.MUST_NOT) ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.SHOULD);
                this._includeIfUnique(booleanQuery, like, queryParser, query, occur);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
    }

    @Override
    public void addTerm(BooleanQuery booleanQuery, String field, String[] values, boolean like) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.addTerm(booleanQuery, field, value, like);
            ++n2;
        }
    }

    @Override
    @Deprecated
    public void cleanUp(IndexSearcher indexSearcher) {
        if (indexSearcher == null) {
            return;
        }
        try {
            indexSearcher.close();
            IndexReader indexReader = indexSearcher.getIndexReader();
            if (indexReader != null) {
                indexReader.close();
            }
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
    }

    @Override
    public int countScoredFieldNames(Query query, String[] filedNames) {
        int count = 0;
        String[] stringArray = filedNames;
        int n = filedNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            WeightedTerm[] weightedTerms = QueryTermExtractor.getTerms(query, false, fieldName);
            if (weightedTerms.length > 0 && !ArrayUtil.contains((Object[])Field.UNSCORED_FIELD_NAMES, (Object)fieldName)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public void delete(long companyId) {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.delete();
    }

    @Override
    public void deleteDocuments(long companyId, Term term) throws IOException {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.deleteDocuments(term);
    }

    @Override
    public void dumpIndex(long companyId, OutputStream outputStream) throws IOException {
        long lastGeneration = this.getLastGeneration(companyId);
        if (lastGeneration == -1L) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Dump index from cluster is not enabled for " + companyId));
            }
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        indexAccessor.dumpIndex(outputStream);
    }

    @Override
    public Analyzer getAnalyzer() {
        return this._analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexAccessor getIndexAccessor(long companyId) {
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor != null) {
            return indexAccessor;
        }
        LuceneHelperImpl luceneHelperImpl = this;
        synchronized (luceneHelperImpl) {
            indexAccessor = this._indexAccessors.get(companyId);
            if (indexAccessor == null) {
                indexAccessor = new IndexAccessorImpl(companyId);
                if (this.isLoadIndexFromClusterEnabled()) {
                    indexAccessor = new SynchronizedIndexAccessorImpl(indexAccessor);
                    boolean clusterForwardMessage = GetterUtil.getBoolean((Object)MessageValuesThreadLocal.getValue((String)"CLUSTER_FORWARD_MESSAGE"));
                    if (clusterForwardMessage) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Skip Luncene index files cluster loading since this is a manual reindex request");
                        }
                    } else {
                        try {
                            this._loadIndexFromCluster(indexAccessor, indexAccessor.getLastGeneration());
                        }
                        catch (Exception e2) {
                            _log.error((Object)("Unable to load index for company " + indexAccessor.getCompanyId()), (Throwable)e2);
                        }
                    }
                }
                this._indexAccessors.put(companyId, indexAccessor);
            }
        }
        return indexAccessor;
    }

    @Override
    public IndexSearcher getIndexSearcher(long companyId) throws IOException {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        return indexAccessor.acquireIndexSearcher();
    }

    @Override
    public long getLastGeneration(long companyId) {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return -1L;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return -1L;
        }
        return indexAccessor.getLastGeneration();
    }

    @Override
    public InputStream getLoadIndexesInputStreamFromCluster(long companyId, Address bootupAddress) throws SystemException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            ObjectValuePair<String, URL> bootupClusterNodeObjectValuePair = this._getBootupClusterNodeObjectValuePair(bootupAddress);
            URL url = (URL)bootupClusterNodeObjectValuePair.getValue();
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            UnsyncPrintWriter unsyncPrintWriter = UnsyncPrintWriterPool.borrow((OutputStream)urlConnection.getOutputStream());
            unsyncPrintWriter.write("transientToken=");
            unsyncPrintWriter.write((String)bootupClusterNodeObjectValuePair.getKey());
            unsyncPrintWriter.write("&companyId=");
            unsyncPrintWriter.write(String.valueOf(companyId));
            unsyncPrintWriter.close();
            inputStream = urlConnection.getInputStream();
            return inputStream;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    @Override
    public Set<String> getQueryTerms(Query query) {
        String queryString = StringUtil.replace((String)query.toString(), (String)"*", (String)"");
        Query tempQuery = null;
        try {
            QueryParser queryParser = new QueryParser(this.getVersion(), "", this.getAnalyzer());
            tempQuery = queryParser.parse(queryString);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to parse " + queryString));
            }
            tempQuery = query;
        }
        WeightedTerm[] weightedTerms = null;
        String[] stringArray = Field.KEYWORDS;
        int n = Field.KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            weightedTerms = QueryTermExtractor.getTerms(tempQuery, false, fieldName);
            if (weightedTerms.length > 0) break;
            ++n2;
        }
        HashSet<String> queryTerms = new HashSet<String>();
        WeightedTerm[] weightedTermArray = weightedTerms;
        int n3 = weightedTerms.length;
        n = 0;
        while (n < n3) {
            WeightedTerm weightedTerm = weightedTermArray[n];
            queryTerms.add(weightedTerm.getTerm());
            ++n;
        }
        return queryTerms;
    }

    @Override
    @Deprecated
    public IndexSearcher getSearcher(long companyId, boolean readOnly) throws IOException {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        IndexReader indexReader = IndexReader.open((Directory)indexAccessor.getLuceneDir(), (boolean)readOnly);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        indexSearcher.setDefaultFieldSortScoring(true, false);
        indexSearcher.setSimilarity((Similarity)new FieldWeightSimilarity());
        return indexSearcher;
    }

    @Override
    public String getSnippet(Query query, String field, String s, int maxNumFragments, int fragmentLength, String fragmentSuffix, Formatter formatter) throws IOException {
        QueryScorer queryScorer = new QueryScorer(query, field);
        Highlighter highlighter = new Highlighter(formatter, (Scorer)queryScorer);
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(fragmentLength));
        TokenStream tokenStream = this.getAnalyzer().tokenStream(field, (Reader)new UnsyncStringReader(s));
        try {
            String snippet = highlighter.getBestFragments(tokenStream, s, maxNumFragments, fragmentSuffix);
            if (Validator.isNotNull((String)snippet) && !StringUtil.endsWith((String)snippet, (String)fragmentSuffix) && !s.equals(snippet)) {
                snippet = snippet.concat(fragmentSuffix);
            }
            return snippet;
        }
        catch (InvalidTokenOffsetsException itoe) {
            throw new IOException(itoe.getMessage());
        }
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public boolean isLoadIndexFromClusterEnabled() {
        if (PropsValues.CLUSTER_LINK_ENABLED && PropsValues.LUCENE_REPLICATE_WRITE) {
            return true;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Load index from cluster is not enabled");
        }
        return false;
    }

    @Override
    public void loadIndex(long companyId, InputStream inputStream) throws IOException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Skip loading Lucene index files for company " + companyId + " in favor of lazy loading"));
            }
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Start loading Lucene index files for company " + companyId));
        }
        indexAccessor.loadIndex(inputStream);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Finished loading index files for company " + companyId + " in " + stopWatch.getTime() + " ms"));
        }
    }

    @Override
    public void loadIndexesFromCluster(long companyId) throws SystemException {
        if (!this.isLoadIndexFromClusterEnabled()) {
            return;
        }
        IndexAccessor indexAccessor = this._indexAccessors.get(companyId);
        if (indexAccessor == null) {
            return;
        }
        long localLastGeneration = this.getLastGeneration(companyId);
        this._loadIndexFromCluster(indexAccessor, localLastGeneration);
    }

    @Override
    public void releaseIndexSearcher(long companyId, IndexSearcher indexSearcher) throws IOException {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        indexAccessor.releaseIndexSearcher(indexSearcher);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this._analyzer = analyzer;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    @Override
    public void shutdown() {
        if (this._luceneIndexThreadPoolExecutor != null) {
            this._luceneIndexThreadPoolExecutor.shutdownNow();
            try {
                this._luceneIndexThreadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                _log.error((Object)"Lucene indexer shutdown interrupted", (Throwable)ie);
            }
        }
        if (this.isLoadIndexFromClusterEnabled()) {
            ClusterExecutorUtil.removeClusterEventListener((ClusterEventListener)this._loadIndexClusterEventListener);
        }
        MessageBus messageBus = MessageBusUtil.getMessageBus();
        for (String searchEngineId : SearchEngineUtil.getSearchEngineIds()) {
            String searchWriterDestinationName = SearchEngineUtil.getSearchWriterDestinationName((String)searchEngineId);
            Destination searchWriteDestination = messageBus.getDestination(searchWriterDestinationName);
            if (searchWriteDestination == null) continue;
            ThreadPoolExecutor threadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)searchWriterDestinationName);
            int maxPoolSize = threadPoolExecutor.getMaxPoolSize();
            CountDownLatch countDownLatch = new CountDownLatch(maxPoolSize);
            ShutdownSyncJob shutdownSyncJob = new ShutdownSyncJob(countDownLatch);
            int i2 = 0;
            while (i2 < maxPoolSize) {
                threadPoolExecutor.submit((Runnable)shutdownSyncJob);
                ++i2;
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException ie) {
                _log.error((Object)"Shutdown waiting interrupted", (Throwable)ie);
            }
            List runnables = threadPoolExecutor.shutdownNow();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Cancelled appending indexing jobs: " + runnables));
            }
            searchWriteDestination.close(true);
        }
        for (IndexAccessor indexAccessor : this._indexAccessors.values()) {
            indexAccessor.close();
        }
    }

    @Override
    public void shutdown(long companyId) {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        this._indexAccessors.remove(indexAccessor);
        indexAccessor.close();
    }

    @Override
    public void startup(long companyId) {
        if (!PropsValues.INDEX_ON_STARTUP) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Indexing Lucene on startup");
        }
        LuceneIndexer luceneIndexer = new LuceneIndexer(companyId);
        if (PropsValues.INDEX_WITH_THREAD) {
            if (this._luceneIndexThreadPoolExecutor == null) {
                this._luceneIndexThreadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)LuceneHelperImpl.class.getName());
            }
            this._luceneIndexThreadPoolExecutor.execute((Runnable)luceneIndexer);
        } else {
            luceneIndexer.reindex();
        }
    }

    @Override
    public void updateDocument(long companyId, Term term, Document document) throws IOException {
        IndexAccessor indexAccessor = this.getIndexAccessor(companyId);
        indexAccessor.updateDocument(term, document);
    }

    private LuceneHelperImpl() {
        if (PropsValues.INDEX_ON_STARTUP && PropsValues.INDEX_WITH_THREAD) {
            this._luceneIndexThreadPoolExecutor = PortalExecutorManagerUtil.getPortalExecutor((String)LuceneHelperImpl.class.getName());
        }
        if (this.isLoadIndexFromClusterEnabled()) {
            this._loadIndexClusterEventListener = new LoadIndexClusterEventListener();
            ClusterExecutorUtil.addClusterEventListener((ClusterEventListener)this._loadIndexClusterEventListener);
        }
        BooleanQuery.setMaxClauseCount((int)_LUCENE_BOOLEAN_QUERY_CLAUSE_MAX_SIZE);
    }

    private ObjectValuePair<String, URL> _getBootupClusterNodeObjectValuePair(Address bootupAddress) throws SystemException {
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((MethodHandler)new MethodHandler(_createTokenMethodKey, new Object[]{_CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT}), (Address[])new Address[]{bootupAddress});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        BlockingQueue clusterNodeResponses = futureClusterResponses.getPartialResults();
        try {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)clusterNodeResponses.poll(_CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT, TimeUnit.MILLISECONDS);
            ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
            int port = clusterNode.getPort();
            if (port <= 0) {
                StringBundler sb = new StringBundler(6);
                sb.append("Invalid cluster node port ");
                sb.append(port);
                sb.append(". The port is set by the first request or ");
                sb.append("configured in portal.properties by the properties ");
                sb.append("\"portal.instance.http.port\" and ");
                sb.append("\"portal.instance.https.port\".");
                throw new Exception(sb.toString());
            }
            String protocol = clusterNode.getPortalProtocol();
            if (Validator.isNull((String)protocol)) {
                StringBundler sb = new StringBundler(4);
                sb.append("Cluster node protocol is empty. The protocol is ");
                sb.append("set by the first request or configured in ");
                sb.append("portal.properties by the property ");
                sb.append("\"portal.instance.protocol\"");
                throw new Exception(sb.toString());
            }
            InetAddress inetAddress = clusterNode.getInetAddress();
            String hostName = null;
            hostName = PropsValues.LUCENE_CLUSTER_INDEX_USE_CANONICAL_HOST_NAME ? inetAddress.getCanonicalHostName() : inetAddress.getHostAddress();
            String fileName = PortalUtil.getPathContext();
            if (!fileName.endsWith("/")) {
                fileName = fileName.concat("/");
            }
            fileName = fileName.concat("lucene/dump");
            URL url = new URL(protocol, hostName, port, fileName);
            String transientToken = (String)clusterNodeResponse.getResult();
            return new ObjectValuePair((Object)transientToken, (Object)url);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    private void _handleFutureClusterResponses(FutureClusterResponses futureClusterResponses, IndexAccessor indexAccessor, int clusterNodeAddressesCount, long localLastGeneration) {
        block22: {
            BlockingQueue blockingQueue = futureClusterResponses.getPartialResults();
            long companyId = indexAccessor.getCompanyId();
            Address bootupAddress = null;
            do {
                --clusterNodeAddressesCount;
                ClusterNodeResponse clusterNodeResponse = null;
                try {
                    clusterNodeResponse = (ClusterNodeResponse)blockingQueue.poll(_CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT, TimeUnit.MILLISECONDS);
                }
                catch (Exception e2) {
                    _log.error((Object)"Unable to get cluster node response", (Throwable)e2);
                }
                if (clusterNodeResponse == null) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get cluster node response in " + _CLUSTER_LINK_NODE_BOOTUP_RESPONSE_TIMEOUT + (Object)((Object)TimeUnit.MILLISECONDS)));
                    continue;
                }
                ClusterNode clusterNode = clusterNodeResponse.getClusterNode();
                if (clusterNode.getPort() > 0) {
                    try {
                        long remoteLastGeneration = (Long)clusterNodeResponse.getResult();
                        if (remoteLastGeneration <= localLastGeneration) continue;
                        bootupAddress = clusterNodeResponse.getAddress();
                        break;
                    }
                    catch (Exception e3) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug((Object)"Suppress exception caused by remote method invocation", (Throwable)e3);
                        continue;
                    }
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Cluster node " + clusterNode + " has invalid port"));
            } while (bootupAddress == null && clusterNodeAddressesCount > 1);
            if (bootupAddress == null) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Start loading lucene index files from cluster node " + bootupAddress));
            }
            InputStream inputStream = null;
            try {
                try {
                    inputStream = this.getLoadIndexesInputStreamFromCluster(companyId, bootupAddress);
                    indexAccessor.loadIndex(inputStream);
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Lucene index files loaded successfully");
                    }
                }
                catch (Exception e4) {
                    _log.error((Object)("Unable to load index for company " + companyId), (Throwable)e4);
                    if (inputStream == null) break block22;
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        _log.error((Object)("Unable to close input stream for company " + companyId), (Throwable)ioe);
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        _log.error((Object)("Unable to close input stream for company " + companyId), (Throwable)ioe);
                    }
                }
            }
        }
    }

    private void _includeIfUnique(BooleanQuery booleanQuery, boolean like, QueryParser queryParser, Query query, BooleanClause.Occur occur) {
        if (query instanceof TermQuery) {
            HashSet terms = new HashSet();
            TermQuery termQuery = (TermQuery)query;
            termQuery.extractTerms(terms);
            float boost = termQuery.getBoost();
            for (Term term : terms) {
                String termValue = term.text();
                if (like) {
                    termValue = termValue.toLowerCase(queryParser.getLocale());
                    term = term.createTerm("*".concat(termValue).concat("*"));
                    query = new WildcardQuery(term);
                } else {
                    query = new TermQuery(term);
                }
                query.setBoost(boost);
                boolean included = false;
                BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
                int n = booleanClauseArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BooleanClause booleanClause = booleanClauseArray[n2];
                    if (query.equals((Object)booleanClause.getQuery())) {
                        included = true;
                    }
                    ++n2;
                }
                if (included) continue;
                booleanQuery.add(query, occur);
            }
        } else if (query instanceof BooleanQuery) {
            BooleanQuery curBooleanQuery = (BooleanQuery)query;
            BooleanQuery containerBooleanQuery = new BooleanQuery();
            BooleanClause[] booleanClauseArray = curBooleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n3 = 0;
            while (n3 < n) {
                BooleanClause booleanClause = booleanClauseArray[n3];
                this._includeIfUnique(containerBooleanQuery, like, queryParser, booleanClause.getQuery(), booleanClause.getOccur());
                ++n3;
            }
            if (containerBooleanQuery.getClauses().length > 0) {
                booleanQuery.add((Query)containerBooleanQuery, occur);
            }
        } else {
            boolean included = false;
            BooleanClause[] booleanClauseArray = booleanQuery.getClauses();
            int n = booleanClauseArray.length;
            int n4 = 0;
            while (n4 < n) {
                BooleanClause booleanClause = booleanClauseArray[n4];
                if (query.equals((Object)booleanClause.getQuery())) {
                    included = true;
                }
                ++n4;
            }
            if (!included) {
                booleanQuery.add(query, occur);
            }
        }
    }

    private void _loadIndexFromCluster(IndexAccessor indexAccessor, long localLastGeneration) throws SystemException {
        List clusterNodeAddresses = ClusterExecutorUtil.getClusterNodeAddresses();
        int clusterNodeAddressesCount = clusterNodeAddresses.size();
        if (clusterNodeAddressesCount <= 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Do not load indexes because there is either one portal instance or no portal instances in the cluster");
            }
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((MethodHandler)new MethodHandler(_getLastGenerationMethodKey, new Object[]{indexAccessor.getCompanyId()}), (boolean)true);
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        this._handleFutureClusterResponses(futureClusterResponses, indexAccessor, clusterNodeAddressesCount, localLastGeneration);
    }

    private class LoadIndexClusterEventListener
    implements ClusterEventListener {
        private LoadIndexClusterEventListener() {
        }

        public void processClusterEvent(ClusterEvent clusterEvent) {
            long[] companyIds;
            ClusterEventType clusterEventType = clusterEvent.getClusterEventType();
            if (!clusterEventType.equals((Object)ClusterEventType.JOIN)) {
                return;
            }
            List clusterNodeAddresses = ClusterExecutorUtil.getClusterNodeAddresses();
            List clusterNodes = clusterEvent.getClusterNodes();
            if (clusterNodeAddresses.size() - clusterNodes.size() > 1) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Number of original cluster members is greater than one");
                }
                return;
            }
            long[] lArray = companyIds = PortalInstances.getCompanyIds();
            int n = companyIds.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                this.loadIndexes(companyId);
                ++n2;
            }
            this.loadIndexes(0L);
        }

        private void loadIndexes(long companyId) {
            long lastGeneration = LuceneHelperImpl.this.getLastGeneration(companyId);
            if (lastGeneration == -1L) {
                return;
            }
            try {
                LuceneClusterUtil.loadIndexesFromCluster(companyId);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to load indexes for company " + companyId), (Throwable)e2);
            }
        }
    }

    private static class ShutdownSyncJob
    implements Runnable {
        private final CountDownLatch _countDownLatch;

        public ShutdownSyncJob(CountDownLatch countDownLatch) {
            this._countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._countDownLatch.countDown();
            try {
                ShutdownSyncJob shutdownSyncJob = this;
                synchronized (shutdownSyncJob) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

