/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sanitizer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.sanitizer.Sanitizer;
import com.liferay.portal.kernel.sanitizer.SanitizerException;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class SanitizerImpl
implements Sanitizer {
    private static Log _log = LogFactoryUtil.getLog(SanitizerImpl.class);
    private List<Sanitizer> _sanitizers = new CopyOnWriteArrayList<Sanitizer>();

    public SanitizerImpl() {
        String[] stringArray = PropsValues.SANITIZER_IMPL;
        int n = PropsValues.SANITIZER_IMPL.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (!Validator.isNull((String)className)) {
                try {
                    Sanitizer sanitizer = (Sanitizer)InstanceFactory.newInstance((String)className);
                    this.registerSanitizer(sanitizer);
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                }
            }
            ++n2;
        }
    }

    public void registerSanitizer(Sanitizer sanitizer) {
        this._sanitizers.add(sanitizer);
    }

    public byte[] sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, byte[] bytes, Map<String, Object> options) throws SanitizerException {
        for (Sanitizer sanitizer : this._sanitizers) {
            bytes = sanitizer.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, bytes, options);
        }
        return bytes;
    }

    public void sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, InputStream inputStream, OutputStream outputStream, Map<String, Object> options) throws SanitizerException {
        if (this._sanitizers.isEmpty()) {
            return;
        }
        if (this._sanitizers.size() == 1) {
            this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, inputStream, outputStream, options);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException ioe) {
            throw new SanitizerException((Throwable)ioe);
        }
        byte[] bytes = this.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, byteArrayOutputStream.toByteArray(), options);
        try {
            outputStream.write(bytes);
        }
        catch (IOException ioe) {
            throw new SanitizerException((Throwable)ioe);
        }
    }

    public String sanitize(long companyId, long groupId, long userId, String className, long classPK, String contentType, String[] modes, String s, Map<String, Object> options) throws SanitizerException {
        for (Sanitizer sanitizer : this._sanitizers) {
            s = sanitizer.sanitize(companyId, groupId, userId, className, classPK, contentType, modes, s, options);
        }
        return s;
    }

    public void unregisterSanitizer(Sanitizer sanitizer) {
        this._sanitizers.remove(sanitizer);
    }
}

