/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.cmis;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;

public class CMISRepositoryDetector {
    private static final String _NUXEO_ID = "Nuxeo";
    private boolean _nuxeo;
    private boolean _nuxeo5_4;
    private boolean _nuxeo5_5OrHigher;
    private boolean _nuxeo5_8OrHigher;

    public CMISRepositoryDetector(RepositoryInfo repositoryInfo) {
        this.detectVendor(repositoryInfo);
    }

    public boolean isNuxeo() {
        return this._nuxeo;
    }

    public boolean isNuxeo5_4() {
        return this._nuxeo5_4;
    }

    public boolean isNuxeo5_5OrHigher() {
        return this._nuxeo5_5OrHigher;
    }

    public boolean isNuxeo5_8OrHigher() {
        return this._nuxeo5_8OrHigher;
    }

    protected void detectNuxeo(RepositoryInfo repositoryInfo) {
        String productVersion = repositoryInfo.getProductVersion();
        String[] versionParts = StringUtil.split((String)productVersion, (String)".");
        int major = GetterUtil.getInteger((String)versionParts[0]);
        int minor = GetterUtil.getInteger((String)versionParts[1]);
        if (major > 5) {
            this._nuxeo5_8OrHigher = true;
            this._nuxeo5_5OrHigher = true;
        } else if (major == 5) {
            if (minor >= 8) {
                this._nuxeo5_8OrHigher = true;
            }
            if (minor >= 5) {
                this._nuxeo5_5OrHigher = true;
            }
            if (minor == 4) {
                this._nuxeo5_4 = true;
            }
        }
    }

    private void detectVendor(RepositoryInfo repositoryInfo) {
        String productName = repositoryInfo.getProductName();
        if (productName.contains(_NUXEO_ID)) {
            this._nuxeo = true;
            this.detectNuxeo(repositoryInfo);
        }
    }
}

