package org.gcube.portal.clientcontext.client;

import com.google.gwt.core.client.EntryPoint;

/**
 * 
 * @author Massimiliano Assante CNR-ISTI
 *
 */
public class GCubeClientContext implements EntryPoint {
	public static final String VRE_ID_ATTR_NAME = "gcube-vreid";
	public static final String USER_ID_ATTR_NAME = "gcube-userId";

	public void onModuleLoad() {}

	public static native String getCurrentVREid() /*-{
		var groupId;
		if ($wnd.Liferay != null) {
			groupId = $wnd.Liferay.ThemeDisplay.getScopeGroupId();
				console.log("VREid is = " + groupId);
		}
		return groupId;
	}-*/;
	
	public static native String getCurrentUserid() /*-{
	var userId;
	if ($wnd.Liferay != null) {
		userId = $wnd.Liferay.ThemeDisplay.getScopeGroupId();
			console.log("VREid is = " + userId);
	}
	return userId;
	}-*/;
	
	public static native void injectContext() /*-{
		if ($wnd.Liferay != null) {
			var userId;
			var groupId;
			if ($wnd.Liferay.ThemeDisplay.isSignedIn()) {
				userId = $wnd.Liferay.ThemeDisplay.getUserId();
			 	groupId = $wnd.Liferay.ThemeDisplay.getScopeGroupId();
			 	console.log('userId is = ' + userId);
			 	console.log("groupId is = " + groupId);
			}
			else {
		    	groupId = $wnd.Liferay.ThemeDisplay.getScopeGroupId();
		    	console.log('Not logged in, injecting groupId only');
			}

			$wnd.XMLHttpRequest.prototype.realSend = $wnd.XMLHttpRequest.prototype.send;
			var newSend = function(vData) {
				this.setRequestHeader(@org.gcube.portal.clientcontext.client.GCubeClientContext::USER_ID_ATTR_NAME, userId);
				this.setRequestHeader(@org.gcube.portal.clientcontext.client.GCubeClientContext::VRE_ID_ATTR_NAME, groupId);
				this.realSend(vData);
			};
			$wnd.XMLHttpRequest.prototype.send = newSend;
		}
	}-*/;
}
