/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.Arrow;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Color;

public class ArrowToolOptions
implements PlugIn,
DialogListener {
    private String colorName;
    private static GenericDialog gd;

    public void run(String arg) {
        if (gd != null && gd.isVisible()) {
            gd.toFront();
        } else {
            this.arrowToolOptions();
        }
    }

    void arrowToolOptions() {
        if (!Toolbar.getToolName().equals("arrow")) {
            IJ.setTool("arrow");
        }
        double width = Arrow.getDefaultWidth();
        double headSize = Arrow.getDefaultHeadSize();
        Color color = Toolbar.getForegroundColor();
        this.colorName = Colors.getColorName(color, "red");
        int style = Arrow.getDefaultStyle();
        gd = new NonBlockingGenericDialog("Arrow Tool");
        gd.addSlider("Width:", 1.0, 50.0, (int)width);
        gd.addSlider("Size:", 0.0, 30.0, headSize);
        gd.addChoice("Color:", Colors.colors, this.colorName);
        gd.addChoice("Style:", Arrow.styles, Arrow.styles[style]);
        gd.addCheckbox("Outline", Arrow.getDefaultOutline());
        gd.addCheckbox("Double head", Arrow.getDefaultDoubleHeaded());
        gd.addDialogListener(this);
        gd.showDialog();
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        double width2 = gd.getNextNumber();
        double headSize2 = gd.getNextNumber();
        String colorName2 = gd.getNextChoice();
        int style2 = gd.getNextChoiceIndex();
        boolean outline2 = gd.getNextBoolean();
        boolean doubleHeaded2 = gd.getNextBoolean();
        if (this.colorName != null && !colorName2.equals(this.colorName)) {
            Color color = Colors.getColor(colorName2, Color.black);
            Toolbar.setForegroundColor(color);
        }
        this.colorName = colorName2;
        Arrow.setDefaultWidth(width2);
        Arrow.setDefaultHeadSize(headSize2);
        Arrow.setDefaultStyle(style2);
        Arrow.setDefaultOutline(outline2);
        Arrow.setDefaultDoubleHeaded(doubleHeaded2);
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return true;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            return true;
        }
        if (roi instanceof Arrow) {
            Arrow arrow = (Arrow)roi;
            roi.setStrokeWidth((float)width2);
            arrow.setHeadSize(headSize2);
            arrow.setStyle(style2);
            arrow.setOutline(outline2);
            arrow.setDoubleHeaded(doubleHeaded2);
            imp.draw();
        }
        Prefs.set("arrow.style", style2);
        Prefs.set("arrow.width", width2);
        Prefs.set("arrow.size", headSize2);
        Prefs.set("arrow.outline", outline2);
        Prefs.set("arrow.double", doubleHeaded2);
        return true;
    }
}

