/*
 * Decompiled with CFR 0.152.
 */
package com.germinus.easyconf.taglib;

import com.germinus.easyconf.ComponentProperties;
import com.germinus.easyconf.EasyConf;
import com.germinus.easyconf.Filter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.RequestUtils;

public class PropertyTag
extends BodyTagSupport {
    private static final long serialVersionUID = 3546082471134573881L;
    private static final String DEFAULT_TYPE = "java.lang.String";
    protected String id = null;
    protected String component = null;
    protected String property = null;
    protected String type = "java.lang.String";
    protected String selector1 = "";
    protected String selector2 = "";
    protected String selector3 = "";
    protected String selector4 = "";
    protected String selector5 = "";
    protected String defaultValue;
    private static final List EMPTY_LIST = new ArrayList();

    public PropertyTag() {
        this.release();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getType() {
        if (StringUtils.isEmpty((String)this.type)) {
            this.type = DEFAULT_TYPE;
        }
        return this.type;
    }

    public void setType(String type) {
        if (StringUtils.isNotEmpty((String)type)) {
            this.type = type;
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSelector1() {
        return this.selector1;
    }

    public void setSelector1(String selector1) {
        this.selector1 = selector1;
    }

    public String getSelector2() {
        return this.selector2;
    }

    public void setSelector2(String selector2) {
        this.selector2 = selector2;
    }

    public String getSelector3() {
        return this.selector3;
    }

    public void setSelector3(String selector3) {
        this.selector3 = selector3;
    }

    public String getSelector4() {
        return this.selector4;
    }

    public void setSelector4(String selector4) {
        this.selector4 = selector4;
    }

    public String getSelector5() {
        return this.selector5;
    }

    public void setSelector5(String selector5) {
        this.selector5 = selector5;
    }

    private String[] getSelectorArray() {
        ArrayList<String> selectors = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.selector1)) {
            selectors.add(this.selector1);
        }
        if (StringUtils.isNotEmpty((String)this.selector2)) {
            selectors.add(this.selector2);
        }
        if (StringUtils.isNotEmpty((String)this.selector3)) {
            selectors.add(this.selector3);
        }
        if (StringUtils.isNotEmpty((String)this.selector4)) {
            selectors.add(this.selector4);
        }
        if (StringUtils.isNotEmpty((String)this.selector5)) {
            selectors.add(this.selector5);
        }
        return selectors.toArray(new String[0]);
    }

    public int doStartTag() throws JspException {
        return 2;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        Object value = null;
        ComponentProperties conf = EasyConf.getConfiguration(this.component).getProperties();
        value = this.readProperty(conf);
        if (value == null) {
            JspException e = new JspException("The value of the property is null");
            RequestUtils.saveException((PageContext)((TagSupport)this).pageContext, (Throwable)e);
            throw e;
        }
        ((TagSupport)this).pageContext.setAttribute(this.id, value);
        return 6;
    }

    /*
     * WARNING - void declaration
     */
    private Object readProperty(ComponentProperties conf) throws JspException {
        void var2_2;
        Object value;
        if (this.getType().equals("java.util.List")) {
            value = conf.getList(this.property, this.getPropertyFilter(), EMPTY_LIST);
        } else if (this.getType().equals("java.lang.Integer")) {
            value = conf.getInteger(this.property, this.getPropertyFilter(), new Integer(0));
        } else if (this.getType().equals("java.lang.String[]")) {
            value = conf.getStringArray(this.property, this.getPropertyFilter(), new String[0]);
        } else if (this.getType().equals(DEFAULT_TYPE)) {
            value = this.defaultValue != null ? conf.getString(this.property, this.getPropertyFilter(), this.defaultValue) : conf.getString(this.property, this.getPropertyFilter());
        } else if (this.getType().equals("java.lang.Double")) {
            value = new Double(conf.getDouble(this.property, this.getPropertyFilter()));
        } else if (this.getType().equals("java.lang.Float")) {
            value = new Float(conf.getFloat(this.property, this.getPropertyFilter()));
        } else if (this.getType().equals("java.lang.Byte")) {
            value = new Byte(conf.getByte(this.property, this.getPropertyFilter()));
        } else if (this.getType().equals("java.math.BigDecimal")) {
            value = conf.getBigDecimal(this.property, this.getPropertyFilter());
        } else if (this.getType().equals("java.lang.BigInteger")) {
            value = conf.getBigInteger(this.property, this.getPropertyFilter());
        } else if (this.getType().equals("java.lang.Boolean")) {
            value = new Boolean(conf.getBoolean(this.property, this.getPropertyFilter()));
        } else if (this.getType().equals("java.lang.Short")) {
            value = new Short(conf.getShort(this.property, this.getPropertyFilter()));
        } else if (this.getType().equals("java.lang.Long")) {
            value = new Long(conf.getLong(this.property, this.getPropertyFilter()));
        } else {
            JspException e = new JspException("Unsupported type: " + this.type);
            RequestUtils.saveException((PageContext)((TagSupport)this).pageContext, (Throwable)e);
            throw e;
        }
        return var2_2;
    }

    private Filter getPropertyFilter() {
        return Filter.by(this.getSelectorArray());
    }

    public void release() {
        super.release();
        this.id = null;
        this.component = null;
        this.property = null;
        this.type = null;
        this.defaultValue = null;
    }
}

