/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.remote;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;

public class BufferIterator
implements RemoteIterator,
Serializable {
    private Object[] buffer;
    private final long size;
    private final RemoteIterator remote;

    public BufferIterator(Object[] buffer, long size, RemoteIterator remote) {
        this.buffer = buffer;
        this.size = size;
        this.remote = remote;
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long items) throws IllegalArgumentException, NoSuchElementException, RemoteException {
        if (items < 0L) {
            throw new IllegalArgumentException("Negative skip is not allowed");
        }
        if (this.buffer == null && items > 0L) {
            throw new NoSuchElementException("Skipped past the last element");
        }
        if (items > (long)this.buffer.length) {
            this.remote.skip(items - (long)this.buffer.length);
            this.buffer = this.remote.nextObjects();
        } else {
            Object[] tmp = new Object[this.buffer.length - (int)items];
            System.arraycopy(this.buffer, (int)items, tmp, 0, tmp.length);
            this.buffer = tmp;
        }
    }

    public Object[] nextObjects() throws RemoteException {
        if (this.buffer == null) {
            return null;
        }
        Object[] tmp = this.buffer;
        this.buffer = this.remote.nextObjects();
        return tmp;
    }
}

