/*
 * Decompiled with CFR 0.152.
 */
package org.jfile.model;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.jfile.model.MagicSection;
import org.jfile.model.MatchAware;
import org.jfile.util.MagicUtil;

public class Magic
implements Comparable<Magic>,
MatchAware<RandomAccessFile> {
    private static final long serialVersionUID = 4478594142230972146L;
    Integer priority = 50;
    String type;
    List<MagicSection> sections;

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public List<MagicSection> getSections() {
        return this.sections;
    }

    public void setSections(List<MagicSection> sections) {
        this.sections = sections;
    }

    @Override
    public int compareTo(Magic magic) {
        return this.priority.compareTo(magic.priority);
    }

    @Override
    public boolean match(RandomAccessFile raf) {
        List<MagicSection> sections = this.getSections();
        for (MagicSection section : sections) {
            try {
                if (!MagicUtil.match(raf, section)) continue;
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public String toString() {
        String retVal = "[" + this.priority + ":" + this.type + "]\n";
        for (MagicSection section : this.sections) {
            retVal = String.valueOf(retVal) + section.toString();
        }
        return retVal;
    }
}

