/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.recurrence;

import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.RDateList;
import com.google.ical.values.RRule;
import com.google.ical.values.WeekdayNum;
import com.liferay.calendar.recurrence.Frequency;
import com.liferay.calendar.recurrence.PositionalWeekday;
import com.liferay.calendar.recurrence.Recurrence;
import com.liferay.calendar.recurrence.Weekday;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class RecurrenceSerializer {
    private static final String _EXDATE = "EXDATE";
    private static Log _log = LogFactoryUtil.getLog(RecurrenceSerializer.class);
    private static Map<Weekday, com.google.ical.values.Weekday> _weekdaysMap = new HashMap<Weekday, com.google.ical.values.Weekday>();

    static {
        _weekdaysMap.put(Weekday.SUNDAY, com.google.ical.values.Weekday.SU);
        _weekdaysMap.put(Weekday.MONDAY, com.google.ical.values.Weekday.MO);
        _weekdaysMap.put(Weekday.TUESDAY, com.google.ical.values.Weekday.TU);
        _weekdaysMap.put(Weekday.WEDNESDAY, com.google.ical.values.Weekday.WE);
        _weekdaysMap.put(Weekday.THURSDAY, com.google.ical.values.Weekday.TH);
        _weekdaysMap.put(Weekday.FRIDAY, com.google.ical.values.Weekday.FR);
        _weekdaysMap.put(Weekday.SATURDAY, com.google.ical.values.Weekday.SA);
    }

    public static Recurrence deserialize(String data) {
        try {
            Recurrence recurrence = new Recurrence();
            int index = data.indexOf("\n");
            if (index != -1) {
                String exceptionDates = data.substring(index + 1, data.length());
                RDateList rDateList = new RDateList(exceptionDates, TimeZone.getTimeZone("UTC"));
                DateValue[] dateValueArray = rDateList.getDatesUtc();
                int n = dateValueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DateValue dateValue = dateValueArray[n2];
                    Calendar jCalendar = RecurrenceSerializer._toJCalendar(dateValue);
                    recurrence.addExceptionDate(jCalendar);
                    ++n2;
                }
                data = data.substring(0, index);
            }
            RRule rRule = new RRule(data);
            recurrence.setCount(rRule.getCount());
            recurrence.setFrequency(Frequency.parse(String.valueOf(rRule.getFreq())));
            recurrence.setInterval(rRule.getInterval());
            DateValue dateValue = rRule.getUntil();
            if (dateValue != null) {
                Calendar jCalendar = RecurrenceSerializer._toJCalendar(dateValue);
                recurrence.setUntilJCalendar(jCalendar);
            }
            ArrayList<PositionalWeekday> positionalWeekdays = new ArrayList<PositionalWeekday>();
            for (WeekdayNum weekdayNum : rRule.getByDay()) {
                Weekday weekday = Weekday.parse(weekdayNum.wday.toString());
                PositionalWeekday positionalWeekday = new PositionalWeekday(weekday, weekdayNum.num);
                positionalWeekdays.add(positionalWeekday);
            }
            recurrence.setPositionalWeekdays(positionalWeekdays);
            recurrence.setMonths(ListUtil.toList((int[])rRule.getByMonth()));
            return recurrence;
        }
        catch (ParseException pe) {
            _log.error((Object)("Unable to parse data " + data), (Throwable)pe);
            return null;
        }
    }

    public static String serialize(Recurrence recurrence) {
        RRule rRule = new RRule();
        ArrayList<WeekdayNum> weekdayNums = new ArrayList<WeekdayNum>();
        for (PositionalWeekday positionalWeekday : recurrence.getPositionalWeekdays()) {
            com.google.ical.values.Weekday wday = _weekdaysMap.get((Object)positionalWeekday.getWeekday());
            WeekdayNum weekdayNum = new WeekdayNum(positionalWeekday.getPosition(), wday);
            weekdayNums.add(weekdayNum);
        }
        rRule.setByDay(weekdayNums);
        List<Integer> months = recurrence.getMonths();
        if (months != null) {
            int[] monthsArray = ArrayUtil.toIntArray(months);
            int i = 0;
            while (i < monthsArray.length) {
                int n = i++;
                monthsArray[n] = monthsArray[n] + 1;
            }
            rRule.setByMonth(monthsArray);
        }
        rRule.setCount(recurrence.getCount());
        com.google.ical.values.Frequency frequency = com.google.ical.values.Frequency.valueOf((String)String.valueOf((Object)recurrence.getFrequency()));
        rRule.setFreq(frequency);
        rRule.setInterval(recurrence.getInterval());
        Calendar jCalendar = recurrence.getUntilJCalendar();
        if (jCalendar != null) {
            DateValue dateValue = RecurrenceSerializer._toDateValue(jCalendar);
            rRule.setUntil(dateValue);
        }
        String data = rRule.toIcal();
        List<Calendar> exceptionJCalendars = recurrence.getExceptionJCalendars();
        if (!exceptionJCalendars.isEmpty()) {
            DateValue[] dateValues = new DateValue[exceptionJCalendars.size()];
            int i = 0;
            while (i < exceptionJCalendars.size()) {
                dateValues[i] = RecurrenceSerializer._toDateValue(exceptionJCalendars.get(i));
                ++i;
            }
            RDateList rDateList = new RDateList(TimeZone.getTimeZone("UTC"));
            rDateList.setDatesUtc(dateValues);
            rDateList.setName(_EXDATE);
            data = data.concat("\n").concat(rDateList.toIcal());
        }
        return data;
    }

    private static DateValue _toDateValue(Calendar jCalendar) {
        DateValueImpl dateValue = new DateValueImpl(jCalendar.get(1), jCalendar.get(2) + 1, jCalendar.get(5));
        return dateValue;
    }

    private static Calendar _toJCalendar(DateValue dateValue) {
        Calendar jCalendar = CalendarFactoryUtil.getCalendar((TimeZone)TimeZone.getTimeZone("UTC"));
        jCalendar.set(5, dateValue.day());
        jCalendar.set(2, dateValue.month() - 1);
        jCalendar.set(1, dateValue.year());
        if (dateValue instanceof DateTimeValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)dateValue;
            jCalendar.set(11, dateTimeValue.hour());
            jCalendar.set(12, dateTimeValue.minute());
            jCalendar.set(13, dateTimeValue.second());
        }
        return jCalendar;
    }
}

