/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library;

import java.util.concurrent.Callable;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;

public class AuthorizedTasks {
    public static <V> Callable<V> bind(final Callable<V> task) {
        final Caller userCall = AuthorizationProvider.instance.get();
        final String token = SecurityTokenProvider.instance.get();
        return new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                AuthorizationProvider.instance.set(userCall);
                SecurityTokenProvider.instance.set(token);
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    AuthorizationProvider.instance.reset();
                    SecurityTokenProvider.instance.reset();
                }
            }
        };
    }

    public static <V> Runnable bind(final Runnable task) {
        final Caller userCall = AuthorizationProvider.instance.get();
        final String token = SecurityTokenProvider.instance.get();
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AuthorizationProvider.instance.set(userCall);
                SecurityTokenProvider.instance.set(token);
                try {
                    task.run();
                }
                finally {
                    AuthorizationProvider.instance.reset();
                    SecurityTokenProvider.instance.reset();
                }
            }
        };
    }
}

