/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class ScanResultSet
extends NoPutResultSetImpl {
    private final boolean tableLocked;
    private final boolean unspecifiedIsolationLevel;
    private final int suppliedLockMode;
    private boolean isolationLevelNeedsUpdate;
    int lockMode;
    int isolationLevel;
    final ExecRowBuilder resultRowBuilder;
    final ExecRow candidate;
    protected final FormatableBitSet accessedCols;

    ScanResultSet(Activation activation, int n, int n2, int n3, boolean bl, int n4, int n5, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.tableLocked = bl;
        this.suppliedLockMode = n3;
        if (n4 == 0) {
            this.unspecifiedIsolationLevel = true;
            n4 = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        } else {
            this.unspecifiedIsolationLevel = false;
        }
        this.lockMode = this.getLockMode(n4);
        this.isolationLevel = this.translateLanguageIsolationLevel(n4);
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.resultRowBuilder = (ExecRowBuilder)execPreparedStatement.getSavedObject(n2);
        this.candidate = this.resultRowBuilder.build(activation.getExecutionFactory());
        this.accessedCols = n5 != -1 ? (FormatableBitSet)execPreparedStatement.getSavedObject(n5) : null;
    }

    void initIsolationLevel() {
        if (this.isolationLevelNeedsUpdate) {
            int n = this.getLanguageConnectionContext().getCurrentIsolationLevel();
            this.lockMode = this.getLockMode(n);
            this.isolationLevel = this.translateLanguageIsolationLevel(n);
            this.isolationLevelNeedsUpdate = false;
        }
    }

    private int getLockMode(int n) {
        if (this.tableLocked || n == 4) {
            return this.suppliedLockMode;
        }
        return 6;
    }

    private int translateLanguageIsolationLevel(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                if (!this.canGetInstantaneousLocks()) {
                    return 2;
                }
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 0;
    }

    abstract boolean canGetInstantaneousLocks();

    public int getScanIsolationLevel() {
        return this.isolationLevel;
    }

    public void close() throws StandardException {
        this.isolationLevelNeedsUpdate = this.unspecifiedIsolationLevel;
        this.candidate.resetRowArray();
        super.close();
    }
}

