/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.test;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.test.ExecutionTestListener;
import com.liferay.portal.kernel.test.ExecutionTestListeners;
import com.liferay.portal.kernel.test.TestContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class TestContextHandler {
    private static Log _log = LogFactoryUtil.getLog(TestContextHandler.class);
    private List<ExecutionTestListener> _executionTestListeners = new ArrayList<ExecutionTestListener>();
    private TestContext _testContext;

    public TestContextHandler(Class<?> clazz) {
        this._testContext = new TestContext(clazz);
        this.registerExecutionListeners(this.getExecutionTestListeners(clazz));
    }

    public void registerExecutionListeners(ExecutionTestListener ... executionTestListeners) {
        ExecutionTestListener[] executionTestListenerArray = executionTestListeners;
        int n = executionTestListeners.length;
        int n2 = 0;
        while (n2 < n) {
            ExecutionTestListener executionTestListener = executionTestListenerArray[n2];
            this._executionTestListeners.add(executionTestListener);
            ++n2;
        }
    }

    public void runAfterTestClasses() {
        for (ExecutionTestListener executionTestListener : this._executionTestListeners) {
            executionTestListener.runAfterClass(this._testContext);
        }
    }

    public void runAfterTestMethod(Object instance, Method method) {
        for (ExecutionTestListener executionTestListener : this._executionTestListeners) {
            executionTestListener.runAfterTest(this._testContext);
        }
    }

    public void runBeforeTestClasses() {
        for (ExecutionTestListener executionTestListener : this._executionTestListeners) {
            executionTestListener.runBeforeClass(this._testContext);
        }
    }

    public void runBeforeTestMethod(Object instance, Method method) {
        this._testContext.setInstance(instance);
        this._testContext.setMethod(method);
        for (ExecutionTestListener executionTestListener : this._executionTestListeners) {
            executionTestListener.runBeforeTest(this._testContext);
        }
    }

    protected ExecutionTestListener[] getExecutionTestListeners(Class<?> clazz) {
        Object executionTestListeners;
        Class<?> declaringClass = ReflectionUtil.getAnnotationDeclaringClass(ExecutionTestListeners.class, clazz);
        ArrayList<Class<? extends ExecutionTestListener>> executionTestListenerClasses = new ArrayList<Class<? extends ExecutionTestListener>>();
        while (declaringClass != null) {
            executionTestListeners = declaringClass.getAnnotation(ExecutionTestListeners.class);
            executionTestListenerClasses.addAll(ListUtil.toList(executionTestListeners.listeners()));
            declaringClass = ReflectionUtil.getAnnotationDeclaringClass(ExecutionTestListeners.class, declaringClass.getSuperclass());
        }
        executionTestListeners = new ExecutionTestListener[executionTestListenerClasses.size()];
        int i = 0;
        while (i < ((Object)executionTestListeners).length) {
            Class executionTestListenerClass = null;
            try {
                executionTestListenerClass = (Class)executionTestListenerClasses.get(i);
                executionTestListeners[i] = (ExecutionTestListener)executionTestListenerClass.newInstance();
            }
            catch (Exception e) {
                _log.error("Unable to instantiate " + executionTestListenerClass, e);
            }
            ++i;
        }
        return executionTestListeners;
    }
}

