/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputBinary
extends RowInputBase
implements RowInputInterface {
    private RowOutputBinary out;

    public RowInputBinary(byte[] buf) {
        super(buf);
    }

    public RowInputBinary(RowOutputBinary out) {
        super(out.getBuffer());
        this.out = out;
    }

    public int readType() throws IOException {
        return this.readShort();
    }

    public String readString() throws IOException {
        int length = this.readInt();
        String s = StringConverter.readUTF(this.buffer, this.pos, length);
        s = ValuePool.getString(s);
        this.pos += length;
        return s;
    }

    protected boolean readNull() throws IOException {
        byte b = this.readByte();
        return b == 0;
    }

    protected String readChar(Type type) throws IOException {
        return this.readString();
    }

    protected Integer readSmallint() throws IOException {
        return ValuePool.getInt(this.readShort());
    }

    protected Integer readInteger() throws IOException {
        return ValuePool.getInt(this.readInt());
    }

    protected Long readBigint() throws IOException {
        return ValuePool.getLong(this.readLong());
    }

    protected Double readReal() throws IOException {
        return ValuePool.getDouble(this.readLong());
    }

    protected BigDecimal readDecimal(Type type) throws IOException {
        byte[] bytes = this.readByteArray();
        int scale = this.readInt();
        BigInteger bigint = new BigInteger(bytes);
        return ValuePool.getBigDecimal(new BigDecimal(bigint, scale));
    }

    protected Boolean readBoole() throws IOException {
        return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected TimeData readTime(Type type) throws IOException {
        if (type.typeCode == 92) {
            return new TimeData(this.readInt(), this.readInt(), 0);
        }
        return new TimeData(this.readInt(), this.readInt(), this.readInt());
    }

    protected TimestampData readDate(Type type) throws IOException {
        long date = this.readLong();
        return new TimestampData(date);
    }

    protected TimestampData readTimestamp(Type type) throws IOException {
        if (type.typeCode == 93) {
            return new TimestampData(this.readLong(), this.readInt());
        }
        return new TimestampData(this.readLong(), this.readInt(), this.readInt());
    }

    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        long months = this.readLong();
        return new IntervalMonthData(months, (IntervalType)type);
    }

    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        long seconds = this.readLong();
        int nanos = this.readInt();
        return new IntervalSecondData(seconds, nanos, (IntervalType)type);
    }

    protected Object readOther() throws IOException {
        return new JavaObjectData(this.readByteArray());
    }

    protected BinaryData readBit() throws IOException {
        int length = this.readInt();
        byte[] b = new byte[(length + 7) / 8];
        this.readFully(b);
        return BinaryData.getBitData(b, length);
    }

    protected BinaryData readBinary() throws IOException {
        return new BinaryData(this.readByteArray(), false);
    }

    protected ClobData readClob() throws IOException {
        long id = super.readLong();
        return new ClobDataID(id);
    }

    protected BlobData readBlob() throws IOException {
        long id = super.readLong();
        return new BlobDataID(id);
    }

    protected Object[] readArray(Type type) throws IOException {
        type = type.collectionBaseType();
        int size = this.readInt();
        Object[] data = new Object[size];
        for (int i = 0; i < size; ++i) {
            data[i] = this.readData(type);
        }
        return data;
    }

    public Object[] readData(Type[] colTypes) throws IOException {
        return super.readData(colTypes);
    }

    public byte[] readByteArray() throws IOException {
        byte[] b = new byte[this.readInt()];
        this.readFully(b);
        return b;
    }

    public char[] readCharArray() throws IOException {
        char[] c = new char[this.readInt()];
        if (this.count - this.pos < c.length) {
            this.pos = this.count;
            throw new EOFException();
        }
        for (int i = 0; i < c.length; ++i) {
            int ch1 = this.buffer[this.pos++] & 0xFF;
            int ch2 = this.buffer[this.pos++] & 0xFF;
            c[i] = (char)((ch1 << 8) + ch2);
        }
        return c;
    }

    public void resetRow(int rowsize) {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.reset();
    }

    public void resetRow(int filepos, int rowsize) throws IOException {
        if (this.out != null) {
            this.out.reset(rowsize);
            this.buffer = this.out.getBuffer();
        }
        super.resetRow(filepos, rowsize);
    }
}

