/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.util.FileDataInput;

public interface SSTableFormat {
    public static final boolean enableSSTableDevelopmentTestMode = Boolean.valueOf(System.getProperty("cassandra.test.sstableformatdevelopment", "false"));

    public Version getLatestVersion();

    public Version getVersion(String var1);

    public SSTableWriter.Factory getWriterFactory();

    public SSTableReader.Factory getReaderFactory();

    public Iterator<OnDiskAtom> getOnDiskIterator(FileDataInput var1, ColumnSerializer.Flag var2, int var3, CFMetaData var4, Version var5);

    public AbstractCompactedRow getCompactedRowWriter(CompactionController var1, ImmutableList<OnDiskAtomIterator> var2);

    public RowIndexEntry.IndexSerializer<?> getIndexSerializer(CFMetaData var1);

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEGACY = new Type("big", BigFormat.instance);
        public static final /* enum */ Type BIG = new Type("big", BigFormat.instance);
        public final SSTableFormat info;
        public final String name;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String name, SSTableFormat info) {
            assert (!CharMatcher.DIGIT.matchesAllOf((CharSequence)name));
            this.name = name;
            this.info = info;
        }

        public static Type validate(String name) {
            for (Type valid : Type.values()) {
                if (valid == LEGACY || !valid.name.equalsIgnoreCase(name)) continue;
                return valid;
            }
            throw new IllegalArgumentException("No Type constant " + name);
        }

        static {
            $VALUES = new Type[]{LEGACY, BIG};
        }
    }
}

