/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompoundDenseCellNameType;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.composites.CompositesIndex;
import org.apache.cassandra.db.marshal.AbstractType;

public class CompositesIndexOnRegular
extends CompositesIndex {
    public static CellNameType buildIndexComparator(CFMetaData baseMetadata, ColumnDefinition columnDef) {
        int prefixSize = columnDef.position();
        ArrayList types = new ArrayList(prefixSize + 1);
        types.add(SecondaryIndex.keyComparator);
        for (int i = 0; i < prefixSize; ++i) {
            types.add(baseMetadata.comparator.subtype(i));
        }
        return new CompoundDenseCellNameType(types);
    }

    @Override
    protected ByteBuffer getIndexedValue(ByteBuffer rowKey, Cell cell) {
        return cell.value();
    }

    @Override
    protected Composite makeIndexColumnPrefix(ByteBuffer rowKey, Composite cellName) {
        CBuilder builder = this.getIndexComparator().prefixBuilder();
        builder.add(rowKey);
        for (int i = 0; i < Math.min(this.columnDef.position(), cellName.size()); ++i) {
            builder.add(cellName.get(i));
        }
        return builder.build();
    }

    @Override
    public CompositesIndex.IndexedEntry decodeEntry(DecoratedKey indexedValue, Cell indexEntry) {
        CBuilder builder = this.baseCfs.getComparator().builder();
        for (int i = 0; i < this.columnDef.position(); ++i) {
            builder.add(indexEntry.name().get(i + 1));
        }
        return new CompositesIndex.IndexedEntry(indexedValue, indexEntry.name(), indexEntry.timestamp(), indexEntry.name().get(0), builder.build());
    }

    @Override
    public boolean indexes(CellName name) {
        AbstractType<?> comp = this.baseCfs.metadata.getColumnDefinitionComparator(this.columnDef);
        return name.size() > this.columnDef.position() && comp.compare(name.get(this.columnDef.position()), this.columnDef.name.bytes) == 0;
    }

    @Override
    public boolean isStale(CompositesIndex.IndexedEntry entry, ColumnFamily data, long now) {
        CellName name = data.getComparator().create(entry.indexedEntryPrefix, this.columnDef);
        Cell cell = data.getColumn(name);
        return cell == null || !cell.isLive(now) || this.columnDef.type.compare(entry.indexValue.getKey(), cell.value()) != 0;
    }
}

