/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictionSet;
import org.apache.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.TermSlice;
import org.apache.cassandra.cql3.restrictions.TokenFilter;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.CompositesBuilder;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class TokenRestriction
extends AbstractPrimaryKeyRestrictions {
    protected final List<ColumnDefinition> columnDefs;

    public TokenRestriction(CType ctype, List<ColumnDefinition> columnDefs) {
        super(ctype);
        this.columnDefs = columnDefs;
    }

    @Override
    public boolean isOnToken() {
        return true;
    }

    @Override
    public Collection<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDefs.get(0);
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDefs.get(this.columnDefs.size() - 1);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager secondaryIndexManager) {
        return false;
    }

    @Override
    public final void addIndexExpressionTo(List<IndexExpression> expressions, SecondaryIndexManager indexManager, QueryOptions options) {
        throw new UnsupportedOperationException("Index expression cannot be created for token restriction");
    }

    @Override
    public CompositesBuilder appendTo(CompositesBuilder builder, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Composite> valuesAsComposites(QueryOptions options) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Composite> boundsAsComposites(Bound bound, QueryOptions options) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    protected final String getColumnNamesAsString() {
        return Joiner.on((String)", ").join(ColumnDefinition.toIdentifiers(this.columnDefs));
    }

    @Override
    public final PrimaryKeyRestrictions mergeWith(Restriction otherRestriction) throws InvalidRequestException {
        if (!otherRestriction.isOnToken()) {
            return new TokenFilter(this.toPrimaryKeyRestriction(otherRestriction), this);
        }
        return this.doMergeWith((TokenRestriction)otherRestriction);
    }

    protected abstract PrimaryKeyRestrictions doMergeWith(TokenRestriction var1) throws InvalidRequestException;

    private PrimaryKeyRestrictions toPrimaryKeyRestriction(Restriction restriction) throws InvalidRequestException {
        if (restriction instanceof PrimaryKeyRestrictions) {
            return (PrimaryKeyRestrictions)restriction;
        }
        return new PrimaryKeyRestrictionSet(this.ctype).mergeWith(restriction);
    }

    public static class Slice
    extends TokenRestriction {
        private final TermSlice slice;

        public Slice(CType ctype, List<ColumnDefinition> columnDefs, Bound bound, boolean inclusive, Term term) {
            super(ctype, columnDefs);
            this.slice = TermSlice.newInstance(bound, inclusive, term);
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.slice.hasBound(b);
        }

        @Override
        public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.slice.bound(b).bindAndGet(options));
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.slice.getFunctions();
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.slice.isInclusive(b);
        }

        @Override
        protected PrimaryKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            if (!otherRestriction.isSlice()) {
                throw RequestValidations.invalidRequest("Columns \"%s\" cannot be restricted by both an equality and an inequality relation", this.getColumnNamesAsString());
            }
            Slice otherSlice = (Slice)otherRestriction;
            if (this.hasBound(Bound.START) && otherSlice.hasBound(Bound.START)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the start bound on %s", this.getColumnNamesAsString());
            }
            if (this.hasBound(Bound.END) && otherSlice.hasBound(Bound.END)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the end bound on %s", this.getColumnNamesAsString());
            }
            return new Slice(this.ctype, this.columnDefs, this.slice.merge(otherSlice.slice));
        }

        public String toString() {
            return String.format("SLICE%s", this.slice);
        }

        private Slice(CType ctype, List<ColumnDefinition> columnDefs, TermSlice slice) {
            super(ctype, columnDefs);
            this.slice = slice;
        }
    }

    public static final class EQ
    extends TokenRestriction {
        private final Term value;

        public EQ(CType ctype, List<ColumnDefinition> columnDefs, Term value) {
            super(ctype, columnDefs);
            this.value = value;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.value.getFunctions();
        }

        @Override
        protected PrimaryKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", Joiner.on((String)", ").join(ColumnDefinition.toIdentifiers(this.columnDefs)));
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }
    }
}

