/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

public class PropertyImplRDB
extends ResourceImplRDB
implements Property {
    protected int ordinal = 0;

    public PropertyImplRDB(Property property, Model model) throws RDFException {
        this(property.getNameSpace(), property.getLocalName(), property.getOrdinal(), model);
    }

    public PropertyImplRDB(String string) throws RDFException {
        super(string);
        if (this.localName == null || this.localName.equals("")) {
            throw new RDFException(2);
        }
        this.checkOrdinal();
    }

    public PropertyImplRDB(String string, String string2) throws RDFException {
        super(string, string2);
        this.checkOrdinal();
    }

    public PropertyImplRDB(String string, Model model) throws RDFException {
        super(string, model);
        if (this.localName == null || this.localName.equals("")) {
            throw new RDFException(2);
        }
        this.checkOrdinal();
    }

    public PropertyImplRDB(String string, String string2, Model model) throws RDFException {
        super(string, string2, model);
        this.checkOrdinal();
    }

    public PropertyImplRDB(String string, String string2, int n, Model model) throws RDFException {
        super(string, string2, model);
        this.ordinal = n;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    protected void checkOrdinal() {
        if (this.localName.charAt(0) == '_' && this.nameSpace.equals(RDF.getURI()) && this.nameSpace.equals(RDF.getURI()) && this.localName.length() > 1) {
            int n = 1;
            while (n < this.localName.length()) {
                char c = this.localName.charAt(n);
                if (c < '0' || c > '9') {
                    return;
                }
                ++n;
            }
            try {
                this.ordinal = Integer.parseInt(this.localName.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                ErrorHelper.logInternalError(this.getClass().getName(), 1);
            }
        }
    }

    public Resource port(Model model) throws RDFException {
        if (this.model == model) {
            return this;
        }
        PropertyImplRDB propertyImplRDB = new PropertyImplRDB(this.nameSpace, this.localName, this.ordinal, model);
        propertyImplRDB.id = this.id;
        return propertyImplRDB;
    }
}

