/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.layoutprototypes.action;

import com.liferay.portal.NoSuchLayoutPrototypeException;
import com.liferay.portal.RequiredLayoutPrototypeException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.LayoutPrototypeServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.layoutprototypes.action.ActionUtil;
import com.liferay.portlet.sites.util.SitesUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditLayoutPrototypeAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateLayoutPrototype(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteLayoutPrototypes(actionRequest);
            } else if (cmd.equals("reset_merge_fail_count")) {
                this.resetMergeFailCount(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.layout_prototypes.error");
            }
            if (e2 instanceof RequiredLayoutPrototypeException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
                if (Validator.isNotNull((String)redirect)) {
                    actionResponse.sendRedirect(redirect);
                }
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getLayoutPrototype((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchLayoutPrototypeException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.layout_prototypes.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.layout_prototypes.edit_layout_prototype"));
    }

    protected void deleteLayoutPrototypes(ActionRequest actionRequest) throws Exception {
        long[] layoutPrototypeIds;
        long[] lArray = layoutPrototypeIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"layoutPrototypeIds"), (long)0L);
        int n = layoutPrototypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            long layoutPrototypeId = lArray[n2];
            LayoutPrototypeServiceUtil.deleteLayoutPrototype((long)layoutPrototypeId);
            ++n2;
        }
    }

    protected void resetMergeFailCount(ActionRequest actionRequest) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        LayoutPrototype layoutPrototype = LayoutPrototypeServiceUtil.getLayoutPrototype((long)layoutPrototypeId);
        SitesUtil.setMergeFailCount((LayoutPrototype)layoutPrototype, (int)0);
    }

    protected void updateLayoutPrototype(ActionRequest actionRequest) throws Exception {
        long layoutPrototypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"layoutPrototypeId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)LayoutPrototype.class.getName(), (PortletRequest)actionRequest);
        if (layoutPrototypeId <= 0L) {
            LayoutPrototypeServiceUtil.addLayoutPrototype((Map)nameMap, (String)description, (boolean)active, (ServiceContext)serviceContext);
        } else {
            LayoutPrototypeServiceUtil.updateLayoutPrototype((long)layoutPrototypeId, (Map)nameMap, (String)description, (boolean)active, (ServiceContext)serviceContext);
        }
    }
}

