/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.propertiesdoc;

import com.liferay.portal.freemarker.FreeMarkerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.tools.ArgumentsUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PropertiesDocIndexBuilder {
    public static void main(String[] args) {
        try {
            new PropertiesDocIndexBuilder(args);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public PropertiesDocIndexBuilder(String[] args) {
        File[] files;
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String propertiesDirName = GetterUtil.getString((String)arguments.get("properties.dir"));
        File propertiesDir = new File(propertiesDirName);
        if (!propertiesDir.exists()) {
            System.out.println(String.valueOf(propertiesDirName) + " not found");
            return;
        }
        ArrayList<String> propertiesHTMLFileNames = new ArrayList<String>();
        File[] fileArray = files = propertiesDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (fileName.endsWith(".properties.html")) {
                String propertiesHTMLFileName = fileName.substring(0, fileName.length() - 5);
                propertiesHTMLFileNames.add(propertiesHTMLFileName);
            }
            ++n2;
        }
        if (propertiesHTMLFileNames.isEmpty()) {
            System.out.println("No properties HTML files found in " + propertiesDirName);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("propertiesHTMLFileNames", propertiesHTMLFileNames);
        context.put("releaseInfoVersion", ReleaseInfo.getVersion());
        try {
            String indexHTMLFileName = String.valueOf(propertiesDirName) + "/index.html";
            File indexHTMLFile = new File(indexHTMLFileName);
            System.out.println("Writing " + indexHTMLFile);
            FileWriter writer = new FileWriter(indexHTMLFile);
            try {
                FreeMarkerUtil.process("com/liferay/portal/tools/propertiesdoc/dependencies/index.ftl", context, writer);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            ((Writer)writer).flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

