/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.ResourceBlock;
import com.liferay.portal.model.ResourceBlockModel;
import com.liferay.portal.model.ResourceBlockSoap;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.model.impl.ResourceBlockCacheModel;
import com.liferay.portal.model.impl.ResourceBlockImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JSON(strict=true)
public class ResourceBlockModelImpl
extends BaseModelImpl<ResourceBlock>
implements ResourceBlockModel {
    public static final String TABLE_NAME = "ResourceBlock";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"resourceBlockId", -5}, {"companyId", -5}, {"groupId", -5}, {"name", 12}, {"permissionsHash", 12}, {"referenceCount", -5}};
    public static final String TABLE_SQL_CREATE = "create table ResourceBlock (resourceBlockId LONG not null primary key,companyId LONG,groupId LONG,name VARCHAR(75) null,permissionsHash VARCHAR(75) null,referenceCount LONG)";
    public static final String TABLE_SQL_DROP = "drop table ResourceBlock";
    public static final String ORDER_BY_JPQL = " ORDER BY resourceBlock.resourceBlockId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY ResourceBlock.resourceBlockId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.entity.cache.enabled.com.liferay.portal.model.ResourceBlock"), (boolean)true);
    public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.finder.cache.enabled.com.liferay.portal.model.ResourceBlock"), (boolean)true);
    public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.portal.model.ResourceBlock"), (boolean)true);
    public static long COMPANYID_COLUMN_BITMASK = 1L;
    public static long GROUPID_COLUMN_BITMASK = 2L;
    public static long NAME_COLUMN_BITMASK = 4L;
    public static long PERMISSIONSHASH_COLUMN_BITMASK = 8L;
    public static long RESOURCEBLOCKID_COLUMN_BITMASK = 16L;
    public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong((String)PropsUtil.get("lock.expiration.time.com.liferay.portal.model.ResourceBlock"));
    private static ClassLoader _classLoader = ResourceBlock.class.getClassLoader();
    private static Class<?>[] _escapedModelInterfaces = new Class[]{ResourceBlock.class};
    private long _resourceBlockId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private String _name;
    private String _originalName;
    private String _permissionsHash;
    private String _originalPermissionsHash;
    private long _referenceCount;
    private long _columnBitmask;
    private ResourceBlock _escapedModel;

    public static ResourceBlock toModel(ResourceBlockSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        ResourceBlockImpl model = new ResourceBlockImpl();
        model.setResourceBlockId(soapModel.getResourceBlockId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setGroupId(soapModel.getGroupId());
        model.setName(soapModel.getName());
        model.setPermissionsHash(soapModel.getPermissionsHash());
        model.setReferenceCount(soapModel.getReferenceCount());
        return model;
    }

    public static List<ResourceBlock> toModels(ResourceBlockSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<ResourceBlock> models = new ArrayList<ResourceBlock>(soapModels.length);
        ResourceBlockSoap[] resourceBlockSoapArray = soapModels;
        int n = soapModels.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceBlockSoap soapModel = resourceBlockSoapArray[n2];
            models.add(ResourceBlockModelImpl.toModel(soapModel));
            ++n2;
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._resourceBlockId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setResourceBlockId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._resourceBlockId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return ResourceBlock.class;
    }

    public String getModelClassName() {
        return ResourceBlock.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("resourceBlockId", this.getResourceBlockId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("groupId", this.getGroupId());
        attributes.put("name", this.getName());
        attributes.put("permissionsHash", this.getPermissionsHash());
        attributes.put("referenceCount", this.getReferenceCount());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Long referenceCount;
        String permissionsHash;
        String name;
        Long groupId;
        Long companyId;
        Long resourceBlockId = (Long)attributes.get("resourceBlockId");
        if (resourceBlockId != null) {
            this.setResourceBlockId(resourceBlockId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((groupId = (Long)attributes.get("groupId")) != null) {
            this.setGroupId(groupId);
        }
        if ((name = (String)attributes.get("name")) != null) {
            this.setName(name);
        }
        if ((permissionsHash = (String)attributes.get("permissionsHash")) != null) {
            this.setPermissionsHash(permissionsHash);
        }
        if ((referenceCount = (Long)attributes.get("referenceCount")) != null) {
            this.setReferenceCount(referenceCount);
        }
    }

    @JSON
    public long getResourceBlockId() {
        return this._resourceBlockId;
    }

    public void setResourceBlockId(long resourceBlockId) {
        this._resourceBlockId = resourceBlockId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._columnBitmask |= COMPANYID_COLUMN_BITMASK;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @JSON
    public long getGroupId() {
        return this._groupId;
    }

    public void setGroupId(long groupId) {
        this._columnBitmask |= GROUPID_COLUMN_BITMASK;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = this._groupId;
        }
        this._groupId = groupId;
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    @JSON
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String name) {
        this._columnBitmask |= NAME_COLUMN_BITMASK;
        if (this._originalName == null) {
            this._originalName = this._name;
        }
        this._name = name;
    }

    public String getOriginalName() {
        return GetterUtil.getString((String)this._originalName);
    }

    @JSON
    public String getPermissionsHash() {
        if (this._permissionsHash == null) {
            return "";
        }
        return this._permissionsHash;
    }

    public void setPermissionsHash(String permissionsHash) {
        this._columnBitmask |= PERMISSIONSHASH_COLUMN_BITMASK;
        if (this._originalPermissionsHash == null) {
            this._originalPermissionsHash = this._permissionsHash;
        }
        this._permissionsHash = permissionsHash;
    }

    public String getOriginalPermissionsHash() {
        return GetterUtil.getString((String)this._originalPermissionsHash);
    }

    @JSON
    public long getReferenceCount() {
        return this._referenceCount;
    }

    public void setReferenceCount(long referenceCount) {
        this._referenceCount = referenceCount;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)ResourceBlock.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public ResourceBlock toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = (ResourceBlock)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])_escapedModelInterfaces, (InvocationHandler)new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        ResourceBlockImpl resourceBlockImpl = new ResourceBlockImpl();
        resourceBlockImpl.setResourceBlockId(this.getResourceBlockId());
        resourceBlockImpl.setCompanyId(this.getCompanyId());
        resourceBlockImpl.setGroupId(this.getGroupId());
        resourceBlockImpl.setName(this.getName());
        resourceBlockImpl.setPermissionsHash(this.getPermissionsHash());
        resourceBlockImpl.setReferenceCount(this.getReferenceCount());
        resourceBlockImpl.resetOriginalValues();
        return resourceBlockImpl;
    }

    public int compareTo(ResourceBlock resourceBlock) {
        long primaryKey = resourceBlock.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBlock)) {
            return false;
        }
        ResourceBlock resourceBlock = (ResourceBlock)obj;
        long primaryKey = resourceBlock.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public void resetOriginalValues() {
        ResourceBlockModelImpl resourceBlockModelImpl = this;
        resourceBlockModelImpl._originalCompanyId = resourceBlockModelImpl._companyId;
        resourceBlockModelImpl._setOriginalCompanyId = false;
        resourceBlockModelImpl._originalGroupId = resourceBlockModelImpl._groupId;
        resourceBlockModelImpl._setOriginalGroupId = false;
        resourceBlockModelImpl._originalName = resourceBlockModelImpl._name;
        resourceBlockModelImpl._originalPermissionsHash = resourceBlockModelImpl._permissionsHash;
        resourceBlockModelImpl._columnBitmask = 0L;
    }

    public CacheModel<ResourceBlock> toCacheModel() {
        String permissionsHash;
        ResourceBlockCacheModel resourceBlockCacheModel = new ResourceBlockCacheModel();
        resourceBlockCacheModel.resourceBlockId = this.getResourceBlockId();
        resourceBlockCacheModel.companyId = this.getCompanyId();
        resourceBlockCacheModel.groupId = this.getGroupId();
        resourceBlockCacheModel.name = this.getName();
        String name = resourceBlockCacheModel.name;
        if (name != null && name.length() == 0) {
            resourceBlockCacheModel.name = null;
        }
        if ((permissionsHash = (resourceBlockCacheModel.permissionsHash = this.getPermissionsHash())) != null && permissionsHash.length() == 0) {
            resourceBlockCacheModel.permissionsHash = null;
        }
        resourceBlockCacheModel.referenceCount = this.getReferenceCount();
        return resourceBlockCacheModel;
    }

    public String toString() {
        StringBundler sb = new StringBundler(13);
        sb.append("{resourceBlockId=");
        sb.append(this.getResourceBlockId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", permissionsHash=");
        sb.append(this.getPermissionsHash());
        sb.append(", referenceCount=");
        sb.append(this.getReferenceCount());
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        StringBundler sb = new StringBundler(22);
        sb.append("<model><model-name>");
        sb.append("com.liferay.portal.model.ResourceBlock");
        sb.append("</model-name>");
        sb.append("<column><column-name>resourceBlockId</column-name><column-value><![CDATA[");
        sb.append(this.getResourceBlockId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>companyId</column-name><column-value><![CDATA[");
        sb.append(this.getCompanyId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>groupId</column-name><column-value><![CDATA[");
        sb.append(this.getGroupId());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>name</column-name><column-value><![CDATA[");
        sb.append(this.getName());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>permissionsHash</column-name><column-value><![CDATA[");
        sb.append(this.getPermissionsHash());
        sb.append("]]></column-value></column>");
        sb.append("<column><column-name>referenceCount</column-name><column-value><![CDATA[");
        sb.append(this.getReferenceCount());
        sb.append("]]></column-value></column>");
        sb.append("</model>");
        return sb.toString();
    }
}

