/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.cost;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.HostingNodeUtils;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.cost.CostComparator;
import gr.uoa.di.madgik.commons.infra.nodeselection.cost.CostFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CostBasedNodeSelector
implements NodeSelector {
    private CostFunction function = null;
    private HostingNode previousSelected = null;
    private static HostingNode localNode = null;
    private NodeSelector tieBreakerSelector = null;
    private static Logger logger = Logger.getLogger(CostBasedNodeSelector.class.getName());

    public CostBasedNodeSelector(CostFunction function) {
        this.function = function;
    }

    public CostBasedNodeSelector(CostFunction function, NodeSelector tieBreaker) {
        this(function);
        this.tieBreakerSelector = tieBreaker;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) {
        HostingNode selected = this.assessNodes(candidates).get((int)0).node;
        this.markSelected(selected);
        return selected;
    }

    @Override
    public List<HostingNodeInfo> assessNodes(List<HostingNode> candidates) {
        float propertyValue;
        boolean skip;
        float max;
        ArrayList<HostingNodeInfo> hns = new ArrayList<HostingNodeInfo>();
        if (candidates.size() == 0) {
            return hns;
        }
        HashMap<HostingNode, Float> assessedNodes = new HashMap<HostingNode, Float>();
        HashMap<String, Float> extremeValues = new HashMap<String, Float>();
        HashSet<String> factorsToRemove = new HashSet<String>();
        this.searchLocal(candidates);
        for (CostFunction.CostFactor costFactor : this.function.getCostFactors()) {
            max = Float.MIN_VALUE;
            skip = false;
            for (HostingNode candidate : candidates) {
                if (!this.isPropertyValid(costFactor.name, candidate)) {
                    factorsToRemove.add(costFactor.name);
                    skip = true;
                    break;
                }
                propertyValue = this.evaluate(costFactor.name, candidate);
                if (!(max < propertyValue)) continue;
                max = propertyValue;
            }
            if (skip) continue;
            extremeValues.put(costFactor.name, Float.valueOf(max));
        }
        for (CostFunction.CostFactor costFactor : this.function.getCostFactors()) {
            max = Float.MIN_VALUE;
            skip = false;
            for (HostingNode candidate : candidates) {
                if (!this.isPropertyValid(costFactor.name, candidate)) {
                    factorsToRemove.add(costFactor.name);
                    skip = true;
                    break;
                }
                propertyValue = this.evaluate(costFactor.name, candidate);
                if (!(max < (propertyValue = this.adjustValue(costFactor.name, candidate, extremeValues, Float.valueOf(propertyValue)).floatValue()))) continue;
                max = propertyValue;
            }
            if (skip) continue;
            extremeValues.put(costFactor.name, Float.valueOf(max));
        }
        this.function.removeCostFactors(factorsToRemove);
        if (this.function.getCostFactors().size() == 0) {
            Collections.shuffle(candidates);
            boolean i = false;
            for (HostingNode candidate : candidates) {
                hns.add(new HostingNodeInfo(candidate, Float.valueOf(1.0f)));
            }
            return hns;
        }
        for (HostingNode hostingNode : candidates) {
            Float val = Float.valueOf(0.0f);
            for (CostFunction.CostFactor factor : this.function.getCostFactors()) {
                Float v = Float.valueOf(this.evaluate(factor.name, hostingNode));
                v = this.adjustValue(factor.name, hostingNode, (Float)extremeValues.get(factor.name), v);
                Float normalizedValue = Float.valueOf(v.floatValue() / ((Float)extremeValues.get(factor.name)).floatValue());
                if (normalizedValue.isNaN() || normalizedValue.isInfinite()) {
                    normalizedValue = Float.valueOf(0.0f);
                }
                if (factor.isAscending()) {
                    val = Float.valueOf(val.floatValue() + factor.getCoefficient() * normalizedValue.floatValue());
                    continue;
                }
                val = Float.valueOf(val.floatValue() + factor.getCoefficient() * (1.0f - normalizedValue.floatValue()));
            }
            assessedNodes.put(hostingNode, val);
        }
        TreeMap<HostingNode, Float> sortedNodes = new TreeMap<HostingNode, Float>(new CostComparator(assessedNodes));
        sortedNodes.putAll(assessedNodes);
        float f = ((Float)sortedNodes.entrySet().iterator().next().getValue()).floatValue();
        for (Map.Entry hn : sortedNodes.entrySet()) {
            hns.add(new HostingNodeInfo((HostingNode)hn.getKey(), Float.valueOf(f != 0.0f ? ((Float)hn.getValue()).floatValue() / f : 1.0f)));
        }
        if (this.tieBreakerSelector != null) {
            return this.resolveTies(hns);
        }
        return hns;
    }

    private List<HostingNodeInfo> resolveTies(List<HostingNodeInfo> hns) {
        ArrayList<HostingNodeInfo> resolvedHns = new ArrayList<HostingNodeInfo>();
        boolean tieFound = false;
        ArrayList<HostingNode> ties = new ArrayList<HostingNode>();
        float tieScore = 0.0f;
        int beforeTieIndex = 0;
        int afterTieIndex = 0;
        if (hns.isEmpty() || hns.size() == 1) {
            return hns;
        }
        boolean resolveTies = false;
        boolean nextRunStart = false;
        for (int i = 1; i < hns.size(); ++i) {
            HostingNodeInfo curr = hns.get(i);
            HostingNodeInfo prev = hns.get(i - 1);
            HostingNodeInfo next = null;
            if (i + 1 < hns.size()) {
                next = hns.get(i + 1);
            }
            if ((double)Math.abs(curr.score.floatValue() - prev.score.floatValue()) < 1.0E-10) {
                if (ties.isEmpty()) {
                    beforeTieIndex = i - 2;
                }
                ties.add(prev.node);
                tieScore = prev.score.floatValue();
                if (next == null || (double)Math.abs(next.score.floatValue() - curr.score.floatValue()) > 1.0E-10) {
                    ties.add(curr.node);
                    afterTieIndex = i + 1;
                    resolveTies = true;
                }
            } else {
                if (!resolveTies && !nextRunStart) {
                    resolvedHns.add(prev);
                }
                if (next == null) {
                    resolvedHns.add(curr);
                }
                nextRunStart = false;
            }
            if (!resolveTies) continue;
            if (ties.size() > 0) {
                float lower;
                float upper;
                List<HostingNodeInfo> tieBreaked = this.tieBreakerSelector.assessNodes(ties);
                boolean interpolate = false;
                float interpolationFactor = 1.0f;
                if (beforeTieIndex == -1) {
                    upper = tieScore;
                } else {
                    upper = hns.get((int)beforeTieIndex).score.floatValue();
                    interpolationFactor = 0.9f;
                    interpolate = true;
                }
                if (afterTieIndex == hns.size()) {
                    lower = tieScore;
                } else {
                    lower = hns.get((int)afterTieIndex).score.floatValue();
                    interpolate = true;
                }
                for (HostingNodeInfo tb : tieBreaked) {
                    resolvedHns.add(new HostingNodeInfo(tb.node, Float.valueOf(lower + tb.score.floatValue() * (upper - lower) * interpolationFactor)));
                }
            }
            resolveTies = false;
            nextRunStart = true;
            ties = new ArrayList();
        }
        return resolvedHns;
    }

    private float evaluate(String factor, HostingNode candidate) {
        if (factor.equals(CostFunction.DistanceToPrevious)) {
            if (this.previousSelected == null) {
                if (candidate.isLocal() || localNode == null) {
                    return HostingNodeUtils.minDistanceInSameNode();
                }
                try {
                    return HostingNodeUtils.distance(candidate, localNode);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not evaluate node distance. Returning " + HostingNodeUtils.minDistanceInSameDomain(), e);
                    return HostingNodeUtils.minDistanceInSameDomain();
                }
            }
            try {
                return HostingNodeUtils.distance(candidate, this.previousSelected);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not evaluate node distance. Returning " + HostingNodeUtils.minDistanceInSameDomain(), e);
                return HostingNodeUtils.minDistanceInSameDomain();
            }
        }
        return Float.parseFloat(candidate.getPropertyByName(factor));
    }

    private boolean isPropertyValid(String factor, HostingNode candidate) {
        if (factor.equals(CostFunction.DistanceToPrevious)) {
            return true;
        }
        return candidate.getPropertyByName(factor) != null;
    }

    private Float adjustValue(String factor, HostingNode candidate, Map<String, Float> extremeValues, Float val) {
        if (this.previousSelected == null || !factor.equals(CostFunction.DistanceToPrevious)) {
            return val;
        }
        if (candidate.getId().equals(this.previousSelected.getId())) {
            extremeValues.put(factor, Float.valueOf(extremeValues.get(factor).floatValue() * 2.0f));
            return extremeValues.get(factor);
        }
        return val;
    }

    private Float adjustValue(String factor, HostingNode candidate, Float extremeValue, Float val) {
        if (this.previousSelected == null || !factor.equals(CostFunction.DistanceToPrevious)) {
            return val;
        }
        if (candidate.getId().equals(this.previousSelected.getId())) {
            return extremeValue;
        }
        return val;
    }

    private void searchLocal(List<HostingNode> candidates) {
        if (localNode == null) {
            for (HostingNode candidate : candidates) {
                if (!candidate.isLocal()) continue;
                localNode = candidate;
                break;
            }
        }
    }

    @Override
    public void markSelected(HostingNode node) {
        this.previousSelected = node;
    }
}

