/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.datatransformationlibrary.datahandlers.impl.clients;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Future;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.contentmanagement.contentmanager.smsplugin.util.GCubeCollections;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.contentmanager.stubs.calls.iterators.RemoteIterator;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.ViewReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.DocumentProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.MetadataProjection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projection;
import org.gcube.contentmanagement.gcubedocumentlibrary.projections.Projections;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.Property;
import org.gcube.contentmanagement.gcubedocumentlibrary.properties.PropertyTypes;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collection;
import org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections;
import org.gcube.contentmanagement.gcubedocumentlibrary.views.MetadataView;
import org.gcube.contentmanagement.gcubemodellibrary.elements.BaseInnerElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeAlternative;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeDocument;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeElement;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubeMetadata;
import org.gcube.contentmanagement.gcubemodellibrary.elements.GCubePart;
import org.gcube.contentmanagement.gcubemodellibrary.elements.MetadataElements;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol.SMSURLConnection;

public class CMCLI {
    public static void main(String[] args) throws MalformedURLException {
        try {
            System.setProperty("java.protocol.handler.pkgs", "org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.protocol");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Scope (/gcube/devNext (default) or /d4science.research-infrastructures.eu/Ecosystem: ");
            String scopestr = in.readLine();
            if (scopestr.equals("")) {
                scopestr = "/gcube/devNext";
            }
            GCUBEScope scope = GCUBEScope.getScope((String)scopestr);
            String str = "";
            while (!str.equalsIgnoreCase("q")) {
                System.out.print("\nQ) Quit\n1) List collections\t2) Find collection by name\t3) Create collection\t4) Delete collection\n5) List collection docs\t6) Get main doc\t7) Get doc content\t8) Get main+meta doc\t9) Add new doc\t10) Del doc\n11) List col views\t12) Create meta view\t13) List meta documents\t14) Add alternative\t15) Add part\t16) Add metadata\t17) Del metadata\n18) List alternatives of a doc\t19) Get alternative\t20) Del metadata view\t21) Get single document from view\t22) Collections with views\n23) Get IDs of a collection\t24) Show views cardinalities\t25) Test single collection\t26) Test view cardinality\t\n");
                str = in.readLine();
                CMCLI.process(in, str, scope);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void process(BufferedReader in, String cmd, GCUBEScope scope) throws IOException {
        if (cmd.equalsIgnoreCase("1")) {
            System.out.println("Collections in " + scope + " :");
            try {
                for (Collection collection : Collections.list((GCUBEScope)scope)) {
                    System.out.println(collection);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("2")) {
            System.out.print("Collection name: ");
            String collectionName = in.readLine();
            System.out.println("Collections in " + scope + " with name \"" + collectionName + "\":");
            try {
                for (Collection collection : Collections.findByName((GCUBEScope)scope, (String)collectionName)) {
                    System.out.println(collection);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("3")) {
            System.out.print("Collection name: ");
            String collectionName = in.readLine();
            System.out.print("Collection description: ");
            String collectionDescription = in.readLine();
            boolean userCollection = true;
            boolean propagateRequest = false;
            boolean readable = true;
            boolean writable = true;
            try {
                List collectionReferences = GCubeCollections.createGCubeCollection((boolean)propagateRequest, (String)collectionName, (String)collectionDescription, (boolean)userCollection, (boolean)readable, (boolean)writable, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                System.out.println("Created collections:");
                for (CollectionReference collectionReference : collectionReferences) {
                    System.out.println("Collection id: " + collectionReference.getCollectionID());
                    if (collectionReference.getReader() != null) {
                        System.out.println("Reader EPR: " + collectionReference.getReader());
                    }
                    if (collectionReference.getWriter() != null) {
                        System.out.println("Writer EPR: " + collectionReference.getWriter());
                    }
                    System.out.println();
                }
                System.out.println("Collections in " + scope + " with name \"" + collectionName + "\":");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("4")) {
            System.out.print("Collection ID: ");
            String collectionId = in.readLine();
            boolean deleteProfile = true;
            System.out.println("Requesting delete:");
            try {
                List results = GCubeCollections.deleteGCubeCollection((String)collectionId, (boolean)deleteProfile, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                System.out.println("Results:");
                for (Future result : results) {
                    RPDocument doc = (RPDocument)result.get();
                    System.out.println("Deleted delegate for collection " + doc.getKey());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("5")) {
            System.out.print("Collection ID: ");
            String collectionId = in.readLine();
            DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
            try {
                System.out.println("Collection ID: " + collectionId);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                RemoteIterator documentIterator = cmReader.get((Projection)dp);
                int i = 0;
                System.out.println("Collection documents:");
                while (documentIterator.hasNext()) {
                    GCubeDocument document = (GCubeDocument)documentIterator.next();
                    String uri = document.uri().toURL().toString();
                    String id = document.id();
                    int parts = document.parts().size();
                    int alternatives = document.alternatives().size();
                    int metadata = document.metadata().size();
                    int annotations = document.annotations().size();
                    System.out.printf("%d id: %s URL: %s parts: %d alternatives: %d metadata: %d annotations: %d %n", i, id, uri, parts, alternatives, metadata, annotations);
                    if (++i <= 5) continue;
                    System.out.println("There are more than " + i + " documents.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("6")) {
            System.out.print("Collection ID: ");
            String collectionId = in.readLine();
            System.out.print("Document ID: ");
            String documentId = in.readLine();
            try {
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.LENGTH, (Property[])new PropertyTypes.DocumentProperty[]{(PropertyTypes.DocumentProperty)Projections.opt((Property)Projections.BYTESTREAM_URI), Projections.NAME});
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                System.out.println("Retrieved document:");
                System.out.println("id: " + document.id());
                System.out.println("name: " + document.name());
                System.out.println("length: " + document.length());
                System.out.println("URL: " + document.uri().toURL().toString());
                if (document.bytestreamURI() != null) {
                    System.out.println("contentURL: " + document.bytestreamURI().toURL().toString());
                }
                System.out.println();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("7")) {
            System.out.print("Collection ID: ");
            String collectionId = in.readLine();
            System.out.print("Document ID: ");
            String documentId = in.readLine();
            System.out.print("Output file: ");
            String outputfile = in.readLine();
            try {
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with(Projections.opt((Property)Projections.BYTESTREAM_URI), (Property[])new PropertyTypes.DocumentProperty[]{(PropertyTypes.DocumentProperty)Projections.opt((Property)Projections.BYTESTREAM), Projections.NAME});
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                System.out.println("Retrieved document:");
                System.out.println("id: " + document.id());
                System.out.println("name: " + document.name());
                System.out.println("document URL: " + document.uri().toURL().toString());
                System.out.println();
                System.out.println("Retrieving content...");
                InputStream ins = CMCLI.getContnetStream((GCubeElement)document, scope);
                if (ins == null) {
                    System.out.println("Document has no content.");
                } else {
                    int len;
                    File f = new File(outputfile);
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] buf = new byte[1024];
                    while ((len = ins.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    ins.close();
                }
                System.out.println("File is created.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("8")) {
            System.out.print("Collection ID: ");
            String collectionId = in.readLine();
            System.out.print("Document ID: ");
            String documentId = in.readLine();
            try {
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.MIME_TYPE, (Property[])new PropertyTypes.DocumentProperty[]{Projections.NAME, Projections.METADATA});
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                System.out.println("Retrieved document:");
                System.out.println("id: " + document.id());
                System.out.println("name: " + document.name());
                System.out.println("mimeType: " + document.mimeType());
                System.out.println("language: " + document.language());
                System.out.println();
                for (GCubeMetadata metadata : document.metadata()) {
                    System.out.println("Metadata:");
                    System.out.println(" id: " + metadata.id());
                    System.out.println(" mimeType: " + metadata.mimeType());
                    System.out.println(" length: " + metadata.length());
                    System.out.println(" Metadata info:");
                    System.out.println("  metadata name: " + metadata.name());
                    System.out.println("  schema name: " + metadata.schemaName());
                    System.out.println("  schema URI: " + metadata.schemaURI().toString());
                    System.out.println("  language: " + metadata.language());
                    byte[] content = metadata.bytestream();
                    String payload = new String(content);
                    System.out.println("  payload: " + payload);
                    System.out.println();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("9")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc name: ");
                String docName = in.readLine();
                System.out.print("Mime type: ");
                String mimetype = in.readLine();
                System.out.print("File: ");
                String fname = in.readLine();
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                GCubeDocument myNewDocument = new GCubeDocument();
                File file = new File(fname);
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                myNewDocument.setMimeType(mimetype);
                myNewDocument.setBytestream((InputStream)bis);
                myNewDocument.setName(docName);
                String myNewDocumentId = cmWriter.add(myNewDocument);
                System.out.println("document created, id: " + myNewDocumentId);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = Projections.document();
                GCubeDocument document = cmReader.get(myNewDocumentId, (Projection)dp);
                System.out.println("Created document:");
                System.out.println("id: " + document.id());
                System.out.println("name: " + document.name());
                System.out.println("mimeType: " + document.mimeType());
                System.out.println("length: " + document.length());
                System.out.println("metadata: " + document.metadata().size());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("10")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc ID: ");
                String documentId = in.readLine();
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                cmWriter.delete(document);
                System.out.println("document removed.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("11")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                List collections = Collections.findById((GCUBEScope)scope, (String)collectionId);
                if (collections.isEmpty()) {
                    System.out.print("Collection not found.");
                }
                MetadataView metadataView = new MetadataView(scope);
                metadataView.setCollectionId(collectionId);
                List views = metadataView.findSimilar();
                System.out.println("found " + views.size() + " views:");
                for (MetadataView view : views) {
                    System.out.println(view);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("12")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("View name: ");
                String viewname = in.readLine();
                String viewdesc = viewname + "_desc";
                System.out.print("View desc: " + viewdesc);
                System.out.print("View metadata schema name: ");
                String viewmetaname = in.readLine();
                System.out.print("View metadata schema URI: ");
                String viewmetaschema = in.readLine();
                MetadataView myView = new MetadataView(scope);
                myView.setCollectionId(collectionId);
                myView.setName(viewname);
                myView.setDescription(viewdesc);
                myView.setProjection(Locale.ENGLISH, viewmetaname, new URI(viewmetaschema));
                myView.setIndexable(true);
                myView.setUserCollection(true);
                myView.setEditable(true);
                myView.setIndexable(false);
                myView.publishAndBroadcast();
                System.out.println("View created: " + myView + " with ID: " + myView.id());
                MetadataView tView = new MetadataView(scope);
                tView.setId(myView.id());
                List newView = tView.findSimilar();
                if (newView.isEmpty()) {
                    System.out.println("Metadata view not there!");
                }
                MetadataView view = (MetadataView)newView.get(0);
                ViewReader reader = view.reader();
                MetadataProjection mp = Projections.metadata();
                System.out.println("Metadata:");
                RemoteIterator iterator = reader.get((Projection)mp);
                while (iterator.hasNext()) {
                    GCubeDocument doc = (GCubeDocument)iterator.next();
                    MetadataElements elements = doc.metadata();
                    for (GCubeMetadata e : elements) {
                        System.out.println(e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("13")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Metadata View ID: ");
                String metadataviewId = in.readLine();
                MetadataView tView = new MetadataView(scope);
                tView.setCollectionId(collectionId);
                tView.setId(metadataviewId);
                List newView = tView.findSimilar();
                MetadataView view = (MetadataView)newView.get(0);
                ViewReader reader = view.reader();
                MetadataProjection mp = Projections.metadata();
                System.out.println("View ID:" + view.id());
                System.out.println("View Schema:" + view.schemaName());
                System.out.println("View Lang:" + view.language());
                System.out.println("View Cardinality:" + view.cardinality());
                System.out.println("Metadata:");
                RemoteIterator iterator = reader.get((Projection)Projections.metadata().withValue((Property)Projections.SCHEMA_URI, (Object)view.schemaURI()));
                int i = 0;
                while (iterator.hasNext()) {
                    GCubeDocument doc = (GCubeDocument)iterator.next();
                    System.out.println("**********DOCUEMNT " + i + " START****************");
                    System.out.println(doc);
                    System.out.println("**********DOCUEMNT END****************");
                    MetadataElements elements = doc.metadata();
                    for (GCubeMetadata e : elements) {
                        System.out.println("************* METADATA START ****************");
                        System.out.println(e);
                        System.out.println(e.uri());
                        System.out.println("************* METADATA END ****************");
                    }
                    if (++i <= 6) continue;
                    System.out.println("We have more than " + i + " documents in this collection.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("14")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc ID: ");
                String documentId = in.readLine();
                System.out.print("Representation doc: ");
                String fname = in.readLine();
                GCubeAlternative alternative = new GCubeAlternative();
                alternative.setMimeType("text/xml");
                alternative.setType("testalternativerole");
                File file = new File(fname);
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                alternative.setBytestream((InputStream)bis);
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                GCubeDocument document = new GCubeDocument(documentId);
                document.trackChanges();
                document.alternatives().add((BaseInnerElement)alternative);
                cmWriter.update(document);
                System.out.println("document updated");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("15")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc ID: ");
                String documentId = in.readLine();
                System.out.print("Part doc: ");
                String fname = in.readLine();
                System.out.print("Part mimetype: ");
                String partmimetype = in.readLine();
                GCubePart part = new GCubePart();
                part.setMimeType(partmimetype);
                File file = new File(fname);
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                part.setBytestream((InputStream)bis);
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                document.setMimeType("multipart/mixed");
                document.parts().add((BaseInnerElement)part);
                cmWriter.update(document);
                System.out.println("document updated");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("16")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc ID: ");
                String documentId = in.readLine();
                System.out.print("Metadata doc: ");
                String fname = in.readLine();
                System.out.print("Metadata schema name: ");
                String metaschemaname = in.readLine();
                System.out.print("Metadata schema URI: ");
                String metaschemaURI = in.readLine();
                System.out.print("Metadata lang: EN\n");
                GCubeMetadata meta = new GCubeMetadata();
                meta.setSchemaName(metaschemaname);
                meta.setSchemaURI(new URI(metaschemaURI));
                meta.setLanguage(Locale.ENGLISH);
                File file = new File(fname);
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream bis = new BufferedInputStream(fis);
                meta.setBytestream((InputStream)bis);
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                document.metadata().add((BaseInnerElement)meta);
                cmWriter.update(document);
                System.out.println("document updated");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("17")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Doc ID: ");
                String documentId = in.readLine();
                System.out.print("Metadata schema name: ");
                String metaschemaname = in.readLine();
                System.out.print("Metadata schema URI: ");
                String metaschemaURI = in.readLine();
                System.out.print("Metadata lang: EN\n");
                GCubeMetadata meta = new GCubeMetadata();
                meta.setSchemaName(metaschemaname);
                meta.setSchemaURI(new URI(metaschemaURI));
                meta.setLanguage(Locale.ENGLISH);
                DocumentWriter cmWriter = new DocumentWriter(collectionId, scope);
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                document.metadata().remove((BaseInnerElement)meta);
                cmWriter.update(document);
                System.out.println("document updated");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("18")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Document ID: ");
                String documentId = in.readLine();
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.ALTERNATIVE, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                for (GCubeAlternative alternative : document.alternatives()) {
                    System.out.println("Alternative ID: " + alternative.id());
                    System.out.println("Mimetype: " + alternative.mimeType());
                    System.out.println("Role: " + alternative.type());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("19")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("Document ID: ");
                String documentId = in.readLine();
                System.out.print("Alternative ID: ");
                String alternativeId = in.readLine();
                System.out.print("Output file: ");
                String outputfile = in.readLine();
                DocumentReader cmReader = new DocumentReader(collectionId, scope);
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.ALTERNATIVE, (Property[])new PropertyTypes.DocumentProperty[0]);
                GCubeDocument document = cmReader.get(documentId, (Projection)dp);
                GCubeAlternative alternative = (GCubeAlternative)document.alternatives().get(alternativeId);
                System.out.println("Alternative ID: " + alternative.id());
                System.out.println("Mimetype: " + alternative.mimeType());
                System.out.println("Role: " + alternative.type());
                InputStream ins = CMCLI.getContnetStream((GCubeElement)alternative, scope);
                if (ins == null) {
                    System.out.println("Alternative has no content.");
                } else {
                    int len;
                    File f = new File(outputfile);
                    FileOutputStream out = new FileOutputStream(f);
                    byte[] buf = new byte[1024];
                    while ((len = ins.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                    ins.close();
                }
                System.out.println("File is created.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("20")) {
            try {
                System.out.print("Collection ID: ");
                String collectionId = in.readLine();
                System.out.print("View ID: ");
                String viewid = in.readLine();
                MetadataView myView = new MetadataView(scope);
                myView.setCollectionId(collectionId);
                myView.setId(viewid);
                myView.publishAndBroadcast();
                System.out.println("View created: " + myView);
                MetadataView tView = new MetadataView(scope);
                tView.setId(myView.id());
                List newView = tView.findSimilar();
                if (newView.isEmpty()) {
                    System.out.println("Metadata view not there!");
                }
                MetadataView view = (MetadataView)newView.get(0);
                ViewReader reader = view.reader();
                MetadataProjection mp = Projections.metadata();
                System.out.println("Metadata:");
                RemoteIterator iterator = reader.get((Projection)mp);
                while (iterator.hasNext()) {
                    GCubeDocument doc = (GCubeDocument)iterator.next();
                    MetadataElements elements = doc.metadata();
                    for (GCubeMetadata e : elements) {
                        System.out.println(e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("21")) {
            System.out.print("View ID: ");
            String viewid = in.readLine();
            System.out.print("Doc ID: ");
            String docId = in.readLine();
            try {
                MetadataView tView = new MetadataView(scope);
                tView.setId(viewid);
                List newView = tView.findSimilar();
                MetadataView view = (MetadataView)newView.get(0);
                ViewReader reader = view.reader();
                MetadataProjection mp = Projections.metadata();
                System.out.println("View ID:" + view.id());
                System.out.println("View Schema:" + view.schemaName());
                System.out.println("View Lang:" + view.language());
                System.out.println("View Cardinality:" + view.cardinality());
                System.out.println("Metadata:");
                GCubeDocument document = reader.get(docId, (Projection)mp);
                System.out.println("Retrieved document:");
                System.out.println("id: " + document.id());
                System.out.println("name: " + document.name());
                System.out.println("mimeType: " + document.mimeType());
                System.out.println();
                for (GCubeMetadata metadata : document.metadata()) {
                    System.out.println("Metadata:");
                    System.out.println(" id: " + metadata.id());
                    System.out.println(" creationTime: " + metadata.creationTime());
                    System.out.println(" mimeType: " + metadata.mimeType());
                    System.out.println(" length: " + metadata.length());
                    System.out.println(" Metadata info:");
                    System.out.println("  metadata name: " + metadata.name());
                    System.out.println("  schema name: " + metadata.schemaName());
                    System.out.println("  schema URI: " + metadata.schemaURI().toString());
                    System.out.println("  language: " + metadata.language());
                    System.out.println();
                    System.out.println("Retrieving metadata content...");
                    InputStream ins = CMCLI.getContnetStream((GCubeElement)metadata, scope);
                    if (ins == null) {
                        System.out.println("Document has no content.");
                    } else {
                        System.out.println("Content: " + CMCLI.convertStreamToString(ins));
                        ins.close();
                    }
                    System.out.println("Done");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("22")) {
            System.out.println("Collections in " + scope + " :");
            try {
                for (Collection collection : Collections.list((GCUBEScope)scope)) {
                    MetadataView metadataView = new MetadataView(scope);
                    metadataView.setCollectionId(collection.getId());
                    List views = metadataView.findSimilar();
                    System.out.println("\nCollection " + collection.getName() + " " + collection.getId() + " has " + views.size() + " views");
                    if (views.size() <= 0) continue;
                    System.out.println("******************");
                    for (MetadataView view : views) {
                        System.out.println(view);
                    }
                    System.out.println("******************");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("23")) {
            System.out.print("Collection ID: ");
            String colid = in.readLine();
            try {
                String id;
                DocumentReader cmReader = new DocumentReader(colid, scope);
                File tempIDsStorage = null;
                tempIDsStorage = File.createTempFile("DTS", ".tmp");
                System.out.println("File storing gDoc IDs: " + tempIDsStorage.getName());
                BufferedWriter out = new BufferedWriter(new FileWriter(tempIDsStorage));
                DocumentProjection dp = (DocumentProjection)Projections.document().with((Property)Projections.NAME, (Property[])new PropertyTypes.DocumentProperty[0]);
                RemoteIterator documentIterator = cmReader.get((Projection)dp);
                int i = 0;
                String seperator = UUID.randomUUID().toString();
                while (documentIterator.hasNext()) {
                    if (++i % 100 == 0) {
                        System.out.println("Pre-fetched IDs for " + i + " docs.");
                    }
                    GCubeDocument document = (GCubeDocument)documentIterator.next();
                    out.write(document.id() + "\n");
                    out.write(document.uri().toString() + "\n");
                    out.write(document.name() + "\n");
                    out.write(seperator + "\n");
                }
                out.close();
                System.out.println("Done prefetching IDs and staff...");
                boolean firstline = true;
                BufferedReader inb = new BufferedReader(new FileReader(tempIDsStorage));
                while ((id = inb.readLine()) != null && !id.isEmpty()) {
                    String uri = inb.readLine();
                    String name = "";
                    String str = inb.readLine();
                    firstline = true;
                    while (!str.equals(seperator)) {
                        if (!firstline) {
                            name = name + "\n";
                        }
                        name = name + str;
                        firstline = false;
                        str = inb.readLine();
                    }
                    System.out.println("ID: " + id + " URI: " + uri + "\nName: " + name);
                    System.out.println("-----------------------------------------");
                }
                inb.close();
                System.out.println("Done");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("24")) {
            try {
                for (Collection collection : Collections.list((GCUBEScope)scope)) {
                    System.out.print(collection.getName() + "\t\t" + collection.getId() + "\t\t");
                    MetadataView metadataView = new MetadataView(scope);
                    metadataView.setCollectionId(collection.getId());
                    List views = metadataView.findSimilar();
                    for (MetadataView view : views) {
                        System.out.print(view.id() + "\t\t" + view.schemaName() + "\t\t" + view.cardinality() + "\t\t");
                    }
                    System.out.println(" ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("25")) {
            System.out.print("Collection ID to test: ");
            String colid = in.readLine();
            try {
                for (Collection collection : Collections.list((GCUBEScope)scope)) {
                    if (!collection.getId().equals(colid)) continue;
                    System.out.print(collection.getName() + "\t" + collection.getId() + "\n");
                    MetadataView metadataView = new MetadataView(scope);
                    metadataView.setCollectionId(collection.getId());
                    List views = metadataView.findSimilar();
                    for (MetadataView view : views) {
                        MetadataProjection mp;
                        System.out.print(view.id() + "\t" + view.schemaName() + "\t" + view.cardinality() + "\n");
                        ViewReader reader = view.reader();
                        RemoteIterator iterator = reader.get((Projection)(mp = Projections.metadata()));
                        if (!iterator.hasNext()) continue;
                        GCubeDocument doc = (GCubeDocument)iterator.next();
                        System.out.println("Doc ID: " + doc.id());
                        MetadataElements elements = doc.metadata();
                        for (GCubeMetadata e : elements) {
                            if (!e.schemaName().equals(view.schemaName())) continue;
                            System.out.println("Meta doc ID: " + e.id());
                            InputStream ins = CMCLI.getContnetStream((GCubeElement)e, scope);
                            if (ins == null) {
                                System.out.println("Document has no content.");
                                continue;
                            }
                            System.out.println("Content: " + CMCLI.convertStreamToString(ins));
                            ins.close();
                        }
                    }
                    System.out.println(" ");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (cmd.equalsIgnoreCase("26")) {
            System.out.print("Meta collection ID to test: ");
            String colid = in.readLine();
            try {
                MetadataView metadataView = new MetadataView(scope);
                metadataView.setId(colid);
                List views = metadataView.findSimilar();
                for (MetadataView view : views) {
                    System.out.print(view.id() + "\t" + view.schemaName() + "\t" + view.cardinality() + "\n");
                    ViewReader reader = view.reader();
                    RemoteIterator iterator = reader.get((Projection)Projections.metadata().withValue((Property)Projections.SCHEMA_URI, (Object)view.schemaURI()));
                    int counter = 0;
                    while (iterator.hasNext()) {
                        GCubeDocument doc = (GCubeDocument)iterator.next();
                        MetadataElements elements = doc.metadata();
                        for (GCubeMetadata e : elements) {
                            if (!e.schemaName().equals(view.schemaName())) continue;
                            ++counter;
                        }
                    }
                    System.out.println("Real cardinality: " + counter);
                }
                System.out.println(" ");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static InputStream getContnetStream(GCubeElement document, GCUBEScope scope) throws MalformedURLException, IOException {
        if (document.bytestreamURI() != null) {
            if (document.bytestreamURI().getScheme().equals("sms")) {
                try {
                    return SMSURLConnection.openConnection((URI)document.bytestreamURI(), (String)scope.toString()).getInputStream();
                }
                catch (URISyntaxException e) {
                    System.out.print("Cannot get stream for metadata, " + document.id());
                    return null;
                }
            }
            return document.bytestreamURI().toURL().openStream();
        }
        if (document.bytestream() != null) {
            byte[] content = document.bytestream();
            ByteArrayInputStream ins = new ByteArrayInputStream(content);
            return ins;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

