/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.commons.vfs2.util.Cryptor;
import org.apache.commons.vfs2.util.CryptorFactory;

public class SmpFileNameParser
extends HostFileNameParser {
    private static final SmpFileNameParser INSTANCE = new SmpFileNameParser();
    private static final int PORT = 21;

    public SmpFileNameParser() {
        super(21);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        Authority auth = this.extractToPath(filename, name);
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String path = name.toString();
        return new GenericFileName(auth.scheme, auth.hostName, auth.port, this.getDefaultPort(), auth.userName, auth.password, path, fileType);
    }

    protected Authority extractToPath(String uri, StringBuilder name) throws FileSystemException {
        String hostName;
        String password;
        String userName;
        Authority auth = new Authority();
        auth.scheme = UriParser.extractScheme((String)uri, (StringBuilder)name);
        if (name.length() < 2 || name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", (Object)uri);
        }
        name.delete(0, 2);
        String userInfo = this.extractUserInfo(name);
        if (userInfo != null) {
            int idx = userInfo.indexOf(58);
            if (idx == -1) {
                userName = userInfo;
                password = null;
            } else {
                userName = userInfo.substring(0, idx);
                password = userInfo.substring(idx + 1);
            }
        } else {
            userName = null;
            password = null;
        }
        auth.userName = UriParser.decode(userName);
        auth.password = UriParser.decode(password);
        if (auth.password != null && auth.password.startsWith("{") && auth.password.endsWith("}")) {
            try {
                Cryptor cryptor = CryptorFactory.getCryptor();
                auth.password = cryptor.decrypt(auth.password.substring(1, auth.password.length() - 1));
            }
            catch (Exception ex) {
                throw new FileSystemException("Unable to decrypt password", (Throwable)ex);
            }
        }
        if ((hostName = this.extractHostName(name)) == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", (Object)uri);
        }
        auth.hostName = hostName;
        auth.port = this.extractPort(name, uri);
        return auth;
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    protected static class Authority
    extends HostFileNameParser.Authority {
        private String scheme;
        private String hostName;
        private String userName;
        private String password;
        private int port;

        protected Authority() {
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

