/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ewe.util.ZipArchive;

public final class ZipUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(File zipped, File directory) throws IOException {
        AnalysisLogger.getLogger().debug((Object)("Unzipping file '" + zipped + "' into '" + directory + "'"));
        try (ZipFile zipFile = new ZipFile(zipped);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(entryDestination);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                ((OutputStream)out).close();
            }
        }
        AnalysisLogger.getLogger().debug((Object)"Unzipped.");
    }

    public static void zipFolder(File root, File zipFile) {
        new ZipArchive(root).zipToFile(zipFile);
    }

    public static void zipFolder(File root, File zipFile, String[] exclude) {
        ZipArchive za = new ZipArchive(root);
        za.exclude(exclude);
        za.zipToFile(zipFile);
    }
}

