/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.exception;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.utils.ReflectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SmartExecutorExceptionMapper {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorExceptionMapper.class);
    protected static final ObjectMapper mapper = new ObjectMapper();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static <T extends OutputStream, EE extends ExecutorException> T marshal(EE object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, EE extends ExecutorException> T marshal(EE object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <EE extends ExecutorException> String marshal(EE object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <EE extends ExecutorException> EE unmarshal(Class<EE> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (EE)((ExecutorException)mapper.readValue(reader, clz));
    }

    public static <EE extends ExecutorException> EE unmarshal(Class<EE> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (EE)((ExecutorException)mapper.readValue(stream, clz));
    }

    public static <EE extends ExecutorException> EE unmarshal(Class<EE> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (EE)((ExecutorException)mapper.readValue(string, clz));
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Package p = ExecutorException.class.getPackage();
        try {
            List<Class<?>> classes = ReflectionUtility.getClassesForPackage(p);
            for (Class<?> clz : classes) {
                logger.trace("Analyzing {}", clz);
                if (!ExecutorException.class.isAssignableFrom(clz)) continue;
                mapper.registerSubtypes(clz);
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Error discovering classes inside package {}", (Object)p.getName(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

