/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.transport.backend;

import com.mongodb.BasicDBObject;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonOperator {
    private GridFS gfs;
    private Logger logger = LoggerFactory.getLogger(BsonOperator.class);

    public BsonOperator(GridFS gfs) {
        this.gfs = gfs;
    }

    protected List<GridFSDBFile> getFilesOnFolder(String folderPath) {
        BasicDBObject queryFile = new BasicDBObject();
        queryFile.put("dir", Pattern.compile(folderPath + "*"));
        List<GridFSDBFile> list = this.gfs.find(queryFile);
        this.logger.info("retrieveRemoteFileObject found " + list.size() + " objects ");
        return list;
    }

    protected List<GridFSDBFile> getOwnedFiles(String username) {
        BasicDBObject queryFile = new BasicDBObject();
        queryFile.put("owner", username);
        List<GridFSDBFile> list = this.gfs.find(queryFile);
        this.logger.info("retrieveUsersFileObjectfound " + list.size() + " objects ");
        return list;
    }
}

