/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.service.operation.OperationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationManager {
    final Logger logger = LoggerFactory.getLogger(OperationManager.class);
    private String[] server;
    private String operation;
    private MyFile resource;
    private boolean isChunk;
    private String bucketName;
    private String fileDest;
    private String backendType;
    private boolean isBase64;
    private String user;
    private String password;
    private String[] dbNames;
    public static final String CLIENT_TYPE = "mongo";
    public static final int MIN_THREAD = 1;
    public static final int MAX_THREAD = 10;
    public static final int sogliaNumeroMassimo = 400;
    public static final int sogliaNumeroMinimo = 4;
    public static final int sogliaDimensioneMinima = 0x100000;
    public static final int sogliaDimensioneMassima = 0x400000;

    public OperationManager(String[] server, String user, String password, String operation, MyFile myFile, String backendType, String[] dbs) {
        this.setServer(server);
        this.setUser(user);
        this.setPassword(password);
        this.setTypeOperation(operation);
        this.setResource(myFile);
        this.setTypeOperation(operation);
        this.setDbNames(dbs);
        this.backendType = backendType;
    }

    public Object startOperation(MyFile file, String remotePath, String author, String[] server, boolean chunkOpt, String rootArea, boolean replaceOption) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("connection(boolean) - start");
        }
        this.logger.info("startOpertion getResource..getGcubeAccessType()= " + (Object)((Object)this.getResource().getGcubeAccessType()) + " file..getGcubeAccessType() " + (Object)((Object)file.getGcubeAccessType()));
        Monitor monitor = new Monitor();
        OperationFactory of = new OperationFactory(server, this.getUser(), this.getPassword(), this.getBucketName(), monitor, chunkOpt, this.getBackendType(), this.getDbNames());
        Operation op = of.getOperation(this.getTypeOperation());
        this.setBucketName(op.initOperation(file, remotePath, author, server, rootArea, replaceOption));
        Object object = op.doIt(this.getResource());
        return object;
    }

    private String getBackendType() {
        return this.backendType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileDest() {
        return this.fileDest;
    }

    public void setFileDest(String fileDest) {
        this.fileDest = fileDest;
    }

    public boolean isChunk() {
        return this.isChunk;
    }

    public void setChunk(boolean isChunk) {
        this.isChunk = isChunk;
    }

    public String[] getServer() {
        return this.server;
    }

    public void setServer(String[] server) {
        this.server = server;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public String getTypeOperation() {
        return this.operation;
    }

    public void setTypeOperation(String operation) {
        this.operation = operation;
    }

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public void setBase64(boolean isBase64) {
        this.isBase64 = isBase64;
    }

    public String[] getDbNames() {
        return this.dbNames;
    }

    public void setDbNames(String[] dbNames) {
        this.dbNames = dbNames;
    }
}

