/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkOptimization {
    final Logger logger = LoggerFactory.getLogger(ChunkOptimization.class);
    private long fileSize;

    public ChunkOptimization(long dimensioneFile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ChunkOptimization(long) - Dimensione del file: " + dimensioneFile);
        }
        this.fileSize = dimensioneFile;
    }

    public int chunkCalculation() {
        long chunkSize = 0L;
        if (this.fileSize <= 0x100000L) {
            chunkSize = this.fileSize;
        } else {
            for (int i = 4; i < 400 && ((chunkSize = this.fileSize / (long)i) >= 0x400000L || chunkSize <= 0x100000L); ++i) {
                if (chunkSize >= 0x100000L) continue;
                chunkSize = 0x100000L;
                break;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The chunk size is " + chunkSize);
        }
        return (int)chunkSize;
    }
}

