/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.plugin;

import java.util.Date;
import java.util.Map;
import org.gcube.vremanagement.executor.persistence.Persistence;
import org.gcube.vremanagement.executor.persistence.PersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Plugin<T extends PluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(Plugin.class);
    private Persistence<? extends PersistenceConnector> persistence;
    private T pluginDeclaration;

    public Plugin(T pluginDeclaration, Persistence<? extends PersistenceConnector> persistence) {
        this.pluginDeclaration = pluginDeclaration;
        this.persistence = persistence;
    }

    public T getPluginDeclaration() {
        return this.pluginDeclaration;
    }

    public void setState(PluginState pluginState) {
        long timestamp = new Date().getTime();
        try {
            this.persistence.addEvolution(timestamp, pluginState);
        }
        catch (Exception e) {
            logger.error(String.format("Unable to persist State : %d,%s", timestamp, pluginState.name()));
        }
    }

    public abstract void launch(Map<String, Object> var1) throws Exception;

    protected abstract void onStop() throws Exception;

    public void stop() throws Exception {
        this.setState(PluginState.SUSPENDED);
        this.onStop();
    }

    public PluginState getState() throws Exception {
        return this.persistence.getState();
    }
}

