/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.oscar;

import java.util.Map;
import org.gcube.dataanalysis.oscar.IncrementalOscarMerger;
import org.gcube.dataanalysis.oscar.OscarImporterPluginDeclaration;
import org.gcube.dataanalysis.oscar.ThreddsUploader;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OscarImporterPlugin
extends Plugin<OscarImporterPluginDeclaration> {
    private IncrementalOscarMerger merger;
    private static final Logger logger = LoggerFactory.getLogger(OscarImporterPlugin.class);

    public OscarImporterPlugin(OscarImporterPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.info("Creating a merger...");
        this.merger = new IncrementalOscarMerger();
    }

    public void launch(Map<String, Object> params) throws Exception {
        logger.info("1. parsing input parameters");
        Integer intervalSize = this.getParameter(params, "intervalSize", 3);
        logger.info("Setting interval size to " + intervalSize);
        this.merger.setIntervalSize(intervalSize);
        Boolean removeTmpFiles = this.getParameter(params, "removeTmpFiles", Boolean.TRUE);
        logger.info("Removing temporary files? " + removeTmpFiles);
        this.merger.setRemoveTmpFiles(removeTmpFiles);
        Boolean debug = this.getParameter(params, "debug", Boolean.FALSE);
        logger.info("Debug mode? " + debug);
        this.merger.setDebug(debug);
        Boolean uploadWithCurl = this.getParameter(params, "uploadWithCurl", Boolean.FALSE);
        logger.info("Upload merged file with cURL (instead of DataTransfer library)? " + uploadWithCurl);
        logger.info("2. create the merged file");
        String mergedFile = this.merger.merge();
        logger.info("3. upload to thredds");
        ThreddsUploader tu = new ThreddsUploader();
        tu.setUploadWithCurl(uploadWithCurl);
        tu.publishOnThredds(mergedFile);
        logger.info("4. cleanup");
        this.merger.cleanup();
    }

    protected void onStop() throws Exception {
        logger.info("4. onStop");
    }

    private Integer getParameter(Map<String, Object> params, String key, Integer defaultValue) {
        Object o;
        if (params != null && (o = params.get(key)) instanceof Integer) {
            return (Integer)o;
        }
        return defaultValue;
    }

    private Boolean getParameter(Map<String, Object> params, String key, Boolean defaultValue) {
        Object o;
        if (params != null && (o = params.get(key)) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    private String getParameter(Map<String, Object> params, String key, String defaultValue) {
        Object o;
        if (params != null && (o = params.get(key)) instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }
}

