/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.oscar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.dataanalysis.oscar.util.ISClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsUploader {
    private static final String DT_PERSISTENCEID = "thredds";
    private static final String DT_SUBFOLDER = "public/netcdf/Oscar";
    private static final Logger logger = LoggerFactory.getLogger(ThreddsUploader.class);

    public boolean publishOnThredds(String fileAbsolutePath) throws Exception {
        List<URL> threddsAddress = new ISClient().getThreddsServicesIDs();
        if (threddsAddress.size() == 0) {
            throw new Exception("Thredds resources is not available in current scope");
        }
        logger.info("Found " + threddsAddress.size() + " thredds services.");
        for (URL u : threddsAddress) {
            logger.info(u.toString());
        }
        URL thredds = threddsAddress.get(0);
        String threddsEndpoint = String.format("%s://%s:%s", thredds.getProtocol(), thredds.getHost(), thredds.getPort());
        logger.info("Picking the first one: " + threddsEndpoint);
        this.uploadUsingCurl(threddsEndpoint, fileAbsolutePath);
        logger.info("Finished");
        return true;
    }

    private void uploadUsingCurl(String dataTransferEndpoint, String fileAbsolutePath) throws Exception {
        String command = "curl";
        command = command + " -F uploadedFile=@" + fileAbsolutePath;
        command = command + " --header gcube-token:" + SecurityTokenProvider.instance.get();
        command = command + " " + dataTransferEndpoint + "/data-transfer-service/gcube/service/REST/FileUpload/" + DT_PERSISTENCEID + "/" + DT_SUBFOLDER;
        command = command + "?on-existing-file=REWRITE";
        command = command + "&on-existing-dir=APPEND";
        command = command + "&create-dirs=true";
        logger.info(command);
        try {
            String s;
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            logger.info("Here is the standard output of the command:\n");
            while ((s = stdInput.readLine()) != null) {
                logger.info(s);
            }
            logger.info("Here is the standard error of the command (if any):\n");
            while ((s = stdError.readLine()) != null) {
                logger.info(s);
            }
            System.exit(0);
        }
        catch (IOException e) {
            logger.info("exception happened - here's what I know: ");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private void uploadUsingLibrary(String threddsEndpoint, String fileAbsolutePath) throws Exception {
        DataTransferClient client = DataTransferClient.getInstanceByEndpoint((String)threddsEndpoint);
        Destination dest = new Destination(fileAbsolutePath);
        dest.setCreateSubfolders(Boolean.valueOf(true));
        dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
        dest.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
        dest.setPersistenceId(DT_PERSISTENCEID);
        dest.setSubFolder(DT_SUBFOLDER);
        client.localFile(fileAbsolutePath, dest);
    }
}

