/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.cover.impl;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.ft.cover.Coverage;
import ucar.nc2.ft.cover.CoverageCS;
import ucar.nc2.ft.cover.impl.CoverageCSImpl;

public class CoverageImpl
implements Coverage {
    private NetcdfDataset ds;
    private CoverageCS ccs;
    private VariableEnhanced ve;
    private VariableDS vds;

    CoverageImpl(NetcdfDataset ds, CoverageCS ccs, VariableEnhanced ve) {
        this.ds = ds;
        this.ccs = ccs;
        this.ve = ve;
        if (ve instanceof VariableDS) {
            this.vds = (VariableDS)ve;
        }
    }

    @Override
    public String getName() {
        return this.ve.getShortName();
    }

    @Override
    public String getFullName() {
        return this.ve.getFullName();
    }

    @Override
    public String getShortName() {
        return this.ve.getShortName();
    }

    @Override
    public String getDescription() {
        return this.ve.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.ve.getUnitsString();
    }

    @Override
    public int getRank() {
        return this.ve.getRank();
    }

    @Override
    public int[] getShape() {
        return this.ve.getShape();
    }

    @Override
    public DataType getDataType() {
        return this.ve.getDataType();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.ve.getAttributes();
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        return this.ve.findAttributeIgnoreCase(name);
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return null;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.ve.getDimensions();
    }

    @Override
    public CoverageCS getCoordinateSystem() {
        return this.ccs;
    }

    @Override
    public boolean hasMissing() {
        return this.vds != null && this.vds.hasMissing();
    }

    @Override
    public boolean isMissing(double val2) {
        return this.vds != null && this.vds.isMissing(val2);
    }

    @Override
    public String getInfo() {
        return null;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.getShortName().compareTo(o.getShortName());
    }

    public String toString() {
        return this.ve.toString();
    }

    @Override
    public Array readData(CoverageCS.Subset subset) throws IOException, InvalidRangeException {
        CoverageCSImpl.SubsetImpl impl = (CoverageCSImpl.SubsetImpl)subset;
        return impl.readData(this.ve);
    }
}

