/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.StationImpl;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.point.RecordDatasetHelper;
import ucar.nc2.dt.point.StationObsDatasetImpl;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class OldUnidataStationObsDataset
extends StationObsDatasetImpl
implements TypedDatasetFactoryIF {
    private NetcdfDataset dataset;
    private RecordDatasetHelper recordHelper;
    private ArrayList records;
    private String latName;
    private String lonName;
    private String elevName;
    private String descName;
    private String timeName;
    private String timeNominalName;
    private String stationIdName;

    public static boolean isValidFile(NetcdfFile ds) {
        String kind = ds.findAttValueIgnoreCase(null, "title", null);
        if (kind == null) {
            return false;
        }
        if ("METAR definition".equals(kind)) {
            return true;
        }
        if ("SYNOPTIC definition".equals(kind)) {
            return true;
        }
        return "BUOY definition".equals(kind);
    }

    @Override
    public boolean isMine(NetcdfDataset ds) {
        return OldUnidataStationObsDataset.isValidFile(ds);
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new OldUnidataStationObsDataset(ncd);
    }

    public OldUnidataStationObsDataset() {
    }

    public OldUnidataStationObsDataset(NetcdfDataset ds) throws IOException {
        super(ds);
        this.dataset = ds;
        String ncmlURL = null;
        String kind = ds.findAttValueIgnoreCase(null, "title", null);
        if ("METAR definition".equals(kind)) {
            Variable v = ds.findVariable("station");
            ncmlURL = v != null ? "resources/nj22/coords/metar2ncMetar.ncml" : "resources/nj22/coords/metar2ncMetar2.ncml";
        } else if ("SYNOPTIC definition".equals(kind)) {
            ncmlURL = "resources/nj22/coords/metar2ncSynoptic.ncml";
        } else if ("BUOY definition".equals(kind)) {
            ncmlURL = "resources/nj22/coords/metar2ncBuoy.ncml";
        }
        if (ncmlURL == null) {
            throw new IOException("unknown StationObsDataset type " + ds.getLocation());
        }
        this.init(ncmlURL);
    }

    public OldUnidataStationObsDataset(NetcdfDataset ds, String ncmlURL) throws IOException {
        super(ds);
        this.dataset = ds;
        this.init(ncmlURL);
    }

    protected void init(String ncmlURL) throws IOException {
        NcMLReader.wrapNcMLresource(this.dataset, ncmlURL, null);
        this.stationIdName = this.dataset.findAttValueIgnoreCase(null, "_StationIdVar", null);
        this.descName = this.dataset.findAttValueIgnoreCase(null, "_StationDescVar", null);
        this.latName = this.dataset.findAttValueIgnoreCase(null, "_StationLatVar", null);
        this.lonName = this.dataset.findAttValueIgnoreCase(null, "_StationLonVar", null);
        this.elevName = this.dataset.findAttValueIgnoreCase(null, "_StationElevVar", null);
        this.timeName = this.dataset.findAttValueIgnoreCase(null, "_StationTimeVar", null);
        this.timeNominalName = this.dataset.findAttValueIgnoreCase(null, "_StationTimeNominalVar", null);
        this.recordHelper = new RecordDatasetHelper(this.dataset, this.timeName, this.timeNominalName, this.dataVariables);
        this.recordHelper.setStationInfo(this.stationIdName, this.descName);
        this.recordHelper.setLocationInfo(this.latName, this.lonName, this.elevName);
        this.removeDataVariable(this.latName);
        this.removeDataVariable(this.lonName);
        this.removeDataVariable(this.elevName);
        this.removeDataVariable(this.timeName);
        this.removeDataVariable(this.timeNominalName);
        this.records = this.recordHelper.readAllCreateObs(null);
        this.stations = new ArrayList<Station>(this.recordHelper.stnHash.values());
        this.setTimeUnits();
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setTimeUnits() {
        this.timeUnit = this.recordHelper.timeUnit;
    }

    @Override
    protected void setStartDate() {
        this.startDate = this.timeUnit.makeDate(this.recordHelper.minDate);
    }

    @Override
    protected void setEndDate() {
        this.endDate = this.timeUnit.makeDate(this.recordHelper.maxDate);
    }

    @Override
    protected void setBoundingBox() {
        this.boundingBox = this.recordHelper.boundingBox;
    }

    @Override
    public List getData(CancelTask cancel) throws IOException {
        return this.records;
    }

    @Override
    public int getDataCount() {
        return this.records.size();
    }

    @Override
    public List getData(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        return this.recordHelper.getData(this.records, boundingBox, cancel);
    }

    @Override
    public List getData(LatLonRect boundingBox, Date start, Date end, CancelTask cancel) throws IOException {
        double startTime = this.timeUnit.makeValue(start);
        double endTime = this.timeUnit.makeValue(end);
        return this.recordHelper.getData(this.records, boundingBox, startTime, endTime, cancel);
    }

    @Override
    public int getStationDataCount(Station s) {
        StationImpl si = (StationImpl)s;
        return si.getNumObservations();
    }

    @Override
    public List getData(Station s, CancelTask cancel) throws IOException {
        return ((StationImpl)s).getObservations();
    }

    @Override
    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return new StationDatatypeIterator(this.recordHelper.recordVar, bufferSize);
    }

    private class StationDatatypeIterator
    extends DatatypeIterator {
        @Override
        protected Object makeDatatypeWithData(int recno, StructureData sdata) {
            RecordDatasetHelper recordDatasetHelper = OldUnidataStationObsDataset.this.recordHelper;
            recordDatasetHelper.getClass();
            return recordDatasetHelper.new RecordDatasetHelper.RecordStationObs(recno, sdata);
        }

        StationDatatypeIterator(Structure struct, int bufferSize) {
            super(struct, bufferSize);
        }
    }
}

