/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection;

public class LambertCylindricalEqualArea
extends AbstractCoordTransBuilder {
    @Override
    public String getTransformName() {
        return "lambert_cylindrical_equal_area";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        double par = this.readAttributeDouble(ctv, "standard_parallel", Double.NaN);
        this.readStandardParams(ds, ctv);
        if (this.earth == null) {
            this.earth = new Earth();
        }
        CylindricalEqualAreaProjection proj = new CylindricalEqualAreaProjection(this.lon0, par, this.false_easting, this.false_northing, this.earth);
        return new ProjectionCT(ctv.getShortName(), "FGDC", proj);
    }
}

