/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.transfer.library.utils.ScopeUtils;
import org.gcube.data.transfer.library.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    private static final Logger log = LoggerFactory.getLogger(StorageUtils.class);

    public static final IClient getClient() {
        return new StorageClient("data-transfer", "data-transfer-library", ScopeUtils.getCurrentCaller(), AccessType.SHARED, MemoryType.VOLATILE).getClient();
    }

    public static final String putOntoStorage(File source) throws RemoteBackendException, FileNotFoundException {
        IClient client = StorageUtils.getClient();
        log.debug("Uploading local file " + source.getAbsolutePath());
        return client.put(true).LFile(new FileInputStream(source)).RFile(Utils.getUniqueString());
    }

    public static final boolean checkStorageId(String id) {
        return StorageUtils.getClient().getHttpUrl().RFile(id) != null;
    }

    public static final String getUrlById(String id) {
        IClient client = StorageUtils.getClient();
        log.debug("Id is " + id);
        return client.getHttpUrl().RFile(id);
    }

    public static final void removeById(String id) {
        IClient client = StorageUtils.getClient();
        client.remove().RFile(id);
    }
}

