/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import org.apache.commons.codec.binary.Base64;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPURLConnectionOld;
import org.gcube.contentmanager.storageclient.model.protocol.smp.StringDecrypter;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.ISClientConnector;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionById
extends SMPConnection {
    private Logger logger = LoggerFactory.getLogger(SMPURLConnectionOld.class);
    private String serviceClass = "Storage-manager";
    private String serviceName = "resolver-uri";
    private String owner = "storage-manager";

    public SMPURLConnectionById(URL url) {
        super(url);
    }

    @Override
    public SMPConnection init(URL url) {
        return new SMPURLConnectionById(url);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        try {
            return this.storageClient(this.url.toString());
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    protected InputStream storageClient(String url) throws Exception {
        this.logger.info("url :" + url);
        String[] urlParam = url.split("/");
        String protocol = urlParam[0];
        protocol = protocol.substring(0, protocol.length() - 1);
        this.logger.debug("protocol is " + protocol);
        if (ScopeProvider.instance.get() == null) {
            throw new RuntimeException("Scope not set");
        }
        String encrypted = this.retrieveStringEncrypted(urlParam);
        MemoryType memory = null;
        if (encrypted.contains("-VLT")) {
            memory = MemoryType.VOLATILE;
            encrypted = encrypted.replace("-VLT", "");
        }
        this.logger.debug("String encrypted " + encrypted);
        String phrase = this.retrieveEncryptionPhrase();
        String location = null;
        if (Base64.isBase64(encrypted) && protocol.equalsIgnoreCase("http")) {
            byte[] valueDecoded = Base64.decodeBase64(encrypted);
            String encryptedID = new String(valueDecoded);
            location = new StringDecrypter("DES", phrase).decrypt(encryptedID);
        } else {
            location = new StringDecrypter("DES", phrase).decrypt(encrypted);
        }
        IClient client = null;
        client = memory != null ? new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED, memory).getClient() : new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED).getClient();
        InputStream is = null;
        is = client.get().RFileAsInputStream(location);
        return is;
    }

    private String retrieveStringEncrypted(String[] urlParam) {
        String encrypted = urlParam[3];
        for (int i = 4; i < urlParam.length; ++i) {
            encrypted = encrypted + "/" + urlParam[i];
        }
        return encrypted;
    }

    @Deprecated
    private String retrieveEncryptionPhrase() throws Exception {
        String currentScope = ScopeProvider.instance.get();
        this.logger.debug("retrieve encryption prhase on scope: " + currentScope);
        String encryptedKey = null;
        ISClientConnector isclient = new ISClientConnector();
        encryptedKey = isclient.retrievePropertyValue("PassPhrase", currentScope);
        String decryptString = StringEncrypter.getEncrypter().decrypt(encryptedKey, new Key[0]);
        return decryptString;
    }
}

