/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.DirectoryBucket;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.TransportManagerFactory;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Remove
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Remove.class);
    public String file_separator = "/";

    public Remove(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        TransportManagerFactory tmf = new TransportManagerFactory(this.server, this.user, this.password);
        TransportManager tm = tmf.getTransport(this.backendType, myFile.getGcubeMemoryType());
        this.removeBucket(tm, this.bucket, myFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" REMOVE " + this.bucket);
        }
        return null;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String[] dirs = remotePath.split(this.file_separator);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("remotePath: " + remotePath);
        }
        String buck = null;
        if (dirs != null && (dirs.length > 1 || dirs.length == 1 && dirs[0].length() < 23)) {
            BucketCoding bc = new BucketCoding();
            buck = bc.bucketFileCoding(remotePath, rootArea);
            if (!"mongo".equalsIgnoreCase("mongo")) {
                buck = buck.replaceAll(this.file_separator, "_-_");
                DirectoryBucket dirBuc = new DirectoryBucket(server, this.user, this.password, remotePath, author);
                dirBuc.removeKeysOnDirBucket(file, buck, rootArea, this.backendType);
                Object var11_11 = null;
            }
        } else {
            buck = remotePath;
        }
        this.bucket = buck;
        return this.bucket;
    }

    public void removeBucket(TransportManager tm, String bucketName, MyFile resource) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("removing file bucket: " + bucketName);
        }
        try {
            tm.removeRemoteFile(this.bucket, resource);
        }
        catch (Exception e) {
            tm.close();
            this.logger.error("Problem in remove: " + this.bucket + ": " + e.getMessage());
            throw new RemoteBackendException(" Error in remove operation ", e.getCause());
        }
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        throw new IllegalArgumentException("Input/Output stream is not compatible with remove operation");
    }
}

