/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.resource;

import java.io.InputStream;
import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.AccessType;
import org.gcube.contentmanagement.blobstorage.resource.MemoryType;
import org.gcube.contentmanagement.blobstorage.resource.OperationDefinition;

public class MyFile {
    private String name;
    private String owner;
    private byte[] content;
    private String localPath;
    private String remotePath;
    private String absoluteRemotePath;
    private int numChunks;
    private String key;
    private String localDir;
    private InputStream inputStream;
    private OutputStream outputStream;
    private String type;
    private boolean lock;
    private String lockedKey;
    private String remoteDir;
    private long lifeTime;
    private String id;
    private long size;
    private String extension;
    private String creationTime;
    private String serviceName;
    private String serviceClass;
    private String ownerGcube;
    private String gcubeScope;
    private AccessType gcubeAccessType;
    private MemoryType gcubeMemoryType;
    private OperationDefinition operation;
    private String resolverHost;
    private boolean forceCreation;
    private String mimeType;
    private String genericPropertyField;
    private String genericPropertyValue;
    private String passPhrase;
    private String writeConcern;
    private String readPreference;
    private String rootPath;
    private boolean replace;

    public MyFile(boolean lock) {
        this.setLock(lock);
    }

    public MyFile(String author, String name, String pathClient, MemoryType memoryType) {
        this.setOwner(author);
        this.setName(name);
        this.setLocalPath(pathClient);
        this.setGcubeMemoryType(memoryType);
    }

    public MyFile(String author, String name, String pathClient, String pathServer, MemoryType memoryType) {
        this.setOwner(author);
        this.setName(name);
        this.setLocalPath(pathClient);
        this.setRemotePath(pathServer);
        this.setGcubeMemoryType(memoryType);
    }

    public MyFile(MemoryType memoryType) {
        this.setGcubeMemoryType(memoryType);
    }

    public MyFile(String name, MemoryType memoryType) {
        this.setName(name);
        this.setGcubeMemoryType(memoryType);
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public void setNumChunks(int numChunks) {
        this.numChunks = numChunks;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String path) {
        this.localPath = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String author) {
        this.owner = author;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] currentChunk) {
        this.content = currentChunk;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public MyFile copyProperties() {
        MyFile dest = new MyFile(this.getGcubeMemoryType());
        dest.setOwner(this.getOwner());
        dest.setLocalDir(this.getLocalDir());
        dest.setRemoteDir(this.getRemoteDir());
        dest.setKey(this.key);
        dest.setName(this.name);
        dest.setNumChunks(this.numChunks);
        dest.setLocalPath(this.localPath);
        dest.setRemotePath(this.remotePath);
        return dest;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String pathServer) {
        this.remotePath = pathServer;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocalDir() {
        return this.localDir;
    }

    public void setLocalDir(String localDir) {
        this.localDir = localDir;
    }

    public String getRemoteDir() {
        return this.remoteDir;
    }

    public void setRemoteDir(String remoteDir) {
        this.remoteDir = remoteDir;
    }

    public String getLockedKey() {
        return this.lockedKey;
    }

    public void setLockedKey(String lockedKey) {
        this.lockedKey = lockedKey;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getOwnerGcube() {
        return this.ownerGcube;
    }

    public void setOwnerGcube(String ownerGcube) {
        this.ownerGcube = ownerGcube;
    }

    public String getGcubeScope() {
        return this.gcubeScope;
    }

    public void setGcubeScope(String gcubeScope) {
        this.gcubeScope = gcubeScope;
    }

    public AccessType getGcubeAccessType() {
        return this.gcubeAccessType;
    }

    public void setGcubeAccessType(AccessType gcubeAccessType) {
        this.gcubeAccessType = gcubeAccessType;
    }

    public MemoryType getGcubeMemoryType() {
        return this.gcubeMemoryType;
    }

    public void setGcubeMemoryType(MemoryType gcubeMemoryType) {
        this.gcubeMemoryType = gcubeMemoryType;
    }

    public void setOperation(OperationDefinition operation) {
        this.operation = operation;
    }

    public void setOperation(OperationDefinition.OPERATION operation) {
        this.operation = new OperationDefinition(operation);
    }

    public OperationDefinition getOperationDefinition() {
        return this.operation;
    }

    public OperationDefinition.LOCAL_RESOURCE getLocalResource() {
        return this.operation.getLocalResource();
    }

    public void setLocalResource(OperationDefinition.LOCAL_RESOURCE localResource) {
        if (this.operation == null) {
            this.operation = new OperationDefinition(OperationDefinition.OPERATION.VOID);
        }
        this.operation.setLocalResource(localResource);
    }

    public OperationDefinition.REMOTE_RESOURCE getRemoteResource() {
        return this.operation.getRemoteResource();
    }

    public void setRemoteResource(OperationDefinition.REMOTE_RESOURCE remoteResource) {
        if (this.operation == null) {
            this.operation = new OperationDefinition(OperationDefinition.OPERATION.VOID);
        }
        this.operation.setRemoteResource(remoteResource);
    }

    public String getAbsoluteRemotePath() {
        return this.absoluteRemotePath;
    }

    public void setAbsoluteRemotePath(String absoluteRemotePath) {
        this.absoluteRemotePath = absoluteRemotePath;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public OperationDefinition getOperation() {
        return this.operation;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public void setResolverHost(String resolverHost) {
        this.resolverHost = resolverHost;
    }

    public String getResolverHOst() {
        return this.resolverHost;
    }

    public void forceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
    }

    public boolean isForceCreation() {
        return this.forceCreation;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public String getGenericPropertyField() {
        return this.genericPropertyField;
    }

    public void setGenericPropertyField(String genericPropertyField) {
        this.genericPropertyField = genericPropertyField;
    }

    public String getGenericPropertyValue() {
        return this.genericPropertyValue;
    }

    public void setGenericPropertyValue(String genericPropertyValue) {
        this.genericPropertyValue = genericPropertyValue;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public String getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(String readConcern) {
        this.readPreference = readConcern;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setReplaceOption(boolean replace) {
        this.replace = replace;
    }

    public boolean isReplace() {
        return this.replace;
    }
}

