/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.iosp.grads.GradsUtil;

public class GradsDimension {
    public static final String LINEAR = "LINEAR";
    public static final String LEVELS = "LEVELS";
    private String name;
    private int size;
    private String mapping;
    private List<String> levels;
    private double[] levelVals;
    private String unitName = "";

    public GradsDimension(String name, int size, String mapping) {
        this.name = name;
        this.size = size;
        this.mapping = mapping;
        this.levels = new ArrayList<String>();
        if (name.equalsIgnoreCase("XDEF")) {
            this.unitName = "degrees_east";
        } else if (name.equalsIgnoreCase("YDEF")) {
            this.unitName = "degrees_north";
        } else if (name.equalsIgnoreCase("ZDEF")) {
            this.unitName = "hPa";
        }
    }

    protected void addLevel(String level) {
        this.levels.add(level);
    }

    protected List<String> getLevels() {
        return this.levels;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public double[] getValues() {
        if (this.levelVals == null) {
            this.levelVals = this.makeLevelValues();
        }
        return this.levelVals;
    }

    public String getUnit() {
        return this.unitName;
    }

    protected void setUnit(String unit) {
        this.unitName = unit;
    }

    public String getType() {
        return this.mapping;
    }

    protected double[] makeLevelValues() {
        int i;
        if (this.levels == null) {
            return null;
        }
        if (this.levels.size() != this.size) {
            // empty if block
        }
        double[] vals = new double[this.size];
        if (this.mapping.equalsIgnoreCase(LEVELS)) {
            for (i = 0; i < vals.length; ++i) {
                vals[i] = Double.parseDouble(this.levels.get(i));
            }
        } else if (this.mapping.equalsIgnoreCase(LINEAR)) {
            double start = 0.0;
            double inc = 0.0;
            start = Double.parseDouble(this.levels.get(0));
            inc = Double.parseDouble(this.levels.get(1));
            for (int i2 = 0; i2 < this.size; ++i2) {
                vals[i2] = start + (double)i2 * inc;
            }
        } else if (this.mapping.toLowerCase().startsWith("gaus")) {
            vals = GradsUtil.getGaussianLatitudes(this.mapping, (int)Double.parseDouble(this.levels.get(0)), this.size);
        }
        if (this.name.equals("ZDEF")) {
            for (i = 0; i < vals.length; ++i) {
                double val2 = vals[i];
                if (val2 > 1050.0) {
                    this.unitName = "Pa";
                    break;
                }
                if (!(val2 < 10.0)) continue;
                this.unitName = "";
                break;
            }
        }
        return vals;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Dimension: ");
        buf.append(this.name.toUpperCase());
        buf.append("\n");
        buf.append("\tSize: ");
        buf.append(this.size);
        buf.append("\n");
        buf.append("\tLevels Size: ");
        buf.append(this.levels.size());
        buf.append("\n");
        buf.append("\tMappingType: ");
        buf.append(this.mapping.toUpperCase());
        buf.append("\n");
        buf.append("\tLevels: ");
        buf.append(this.levels.toString());
        buf.append("\n");
        buf.append("\tUnits: ");
        buf.append(this.unitName);
        buf.append("\n");
        return buf.toString();
    }
}

