/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.transfer.library.client;

import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.library.faults.CommunicationException;
import org.gcube.data.transfer.library.faults.RemoteServiceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.model.TransferCapabilities;
import org.gcube.data.transfer.model.TransferRequest;
import org.gcube.data.transfer.model.TransferTicket;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private static ClientConfig config = null;
    private String endpoint;
    private WebTarget rootTarget;

    public Client(String endpoint) throws ServiceNotFoundException {
        try {
            log.debug("Creating client for base " + endpoint);
            this.endpoint = endpoint + "";
            this.rootTarget = ClientBuilder.newClient(config).target(endpoint).path("data-transfer-service").path("/gcube/service/");
            log.debug("Root Taget IS {} ", (Object)this.rootTarget.getUri());
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public TransferCapabilities getCapabilties() throws CommunicationException {
        WebTarget capabilitiesTarget = this.rootTarget.path("Capabilities");
        log.debug("Getting capabilities from {}, path is {} ", (Object)this.endpoint, (Object)capabilitiesTarget.getUri());
        try {
            Response resp = capabilitiesTarget.request().accept(MediaType.APPLICATION_JSON_TYPE).get();
            this.checkResponse(resp);
            return resp.readEntity(TransferCapabilities.class);
        }
        catch (Exception e) {
            throw new CommunicationException(e);
        }
    }

    public TransferTicket submit(TransferRequest request) throws RemoteServiceException {
        log.debug("Sending request {} to {}", (Object)request, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("Requests").request(MediaType.APPLICATION_JSON_TYPE).post(Entity.entity(request, MediaType.APPLICATION_JSON_TYPE));
            this.checkResponse(resp);
            return resp.readEntity(TransferTicket.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    public TransferTicket getTransferStatus(String transferId) throws RemoteServiceException {
        log.debug("Requesting transfer status [id = {}, endpoint={}]", (Object)transferId, (Object)this.endpoint);
        try {
            Response resp = this.rootTarget.path("TransferStatus").path(transferId).request(MediaType.APPLICATION_JSON_TYPE).get();
            this.checkResponse(resp);
            return resp.readEntity(TransferTicket.class);
        }
        catch (Exception e) {
            throw new RemoteServiceException(e);
        }
    }

    protected void checkResponse(Response toCheck) throws Exception {
        switch (toCheck.getStatusInfo().getFamily()) {
            case SUCCESSFUL: {
                break;
            }
            default: {
                throw new Exception("Unexpected Response code : " + toCheck.getStatus());
            }
        }
    }

    static {
        log.debug("Creating configuration ..");
        config = new ClientConfig();
        config.register((Class)JacksonFeature.class);
        config.register((Class)AuthorizationFilter.class);
    }
}

