package org.gcube.dataanalysis.oscar;

import java.net.URL;
import java.util.List;

import org.gcube.dataanalysis.oscar.util.ISClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * This class in is charge of uploading the generated merged oscar file to the
 * thredds server
 * 
 * @author paolo
 * 
 */
public class ThreddsUploader {

  private static final Logger logger = LoggerFactory
      .getLogger(ThreddsUploader.class);

  public boolean publishOnThredds(String scope, String fileAbsolutePath) throws Exception {
    
    String remoteFolder = "/data/content/thredds/public/netcdf/";
    
    // 1. locate the Thredds service in the current scope
    List<URL> threddsAddress = new ISClient().getThreddsServices();
    if (threddsAddress.size() == 0)
      throw new Exception("Thredds resource is not available in scope " + scope);
    logger.info("Found " + threddsAddress.size() + " thredds services.");
    URL thredds = threddsAddress.get(0);
    logger.info("Picking the first one: " + thredds);
    
    // 2. locate the Data Transfer Services in the current scope
    List<URL> dataTransferAddress = new ISClient().getDataTransferServices();
    if (dataTransferAddress.size() == 0)
      throw new Exception("Data Transfer services are not available in scope " + scope);

    // 3. pick the Data Transfer service located on the Thredds host
    URL dataTransfer = null;
    for(URL address:dataTransferAddress) {
      if(address.getHost().equals(thredds.getHost())) {
        dataTransfer = address;
        break;
      }
    }
    if (dataTransfer==null) {
      throw new Exception("Thredds data transfer has not been found in the same scope of the catalog: " + scope);
    }

    // 4. do transfer
    logger.info("TODO: Transferring files using: " + dataTransfer);
//    this.transferFileToService(scope, dataTransfer.getHost(), 9090, fileAbsolutePath, remoteFolder);

    logger.info("TODO: Adding metadata on GeoNetwork");

    logger.info("Finished");
    return true;
  }
    
}
