/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.units;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.units.TimeUnit;

public class DateType {
    private String text;
    private String format;
    private String type;
    private boolean isPresent;
    private boolean isBlank;
    private final CalendarDate date;

    public DateType(boolean isPresent, Date date) {
        this.isPresent = isPresent;
        this.date = isPresent ? null : CalendarDate.of(date);
    }

    public DateType(CalendarDate date) {
        this.isPresent = false;
        this.date = date;
    }

    public DateType() {
        this.isBlank = true;
        this.date = null;
    }

    public DateType(DateType src) {
        this.text = src.getText();
        this.format = src.getFormat();
        this.type = src.getType();
        this.isPresent = src.isPresent();
        this.isBlank = src.isBlank();
        this.date = src.getCalendarDate();
    }

    public DateType(String text, String format, String type) throws ParseException {
        this.text = text = text == null ? "" : text.trim();
        this.format = format;
        this.type = type;
        if (text.length() == 0) {
            this.isBlank = true;
            this.date = null;
            return;
        }
        this.isPresent = text.equalsIgnoreCase("present");
        if (this.isPresent) {
            this.date = null;
            return;
        }
        if (format != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            Date d = dateFormat.parse(text);
            this.date = CalendarDate.of(d);
            return;
        }
        if (text.indexOf("since") > 0) {
            this.date = CalendarDate.parseUdunits(null, text);
            if (this.date == null) {
                throw new ParseException("invalid udunit date unit =" + text, 0);
            }
            return;
        }
        this.date = CalendarDate.parseISOformat(null, text);
        if (this.date == null) {
            throw new ParseException("invalid ISO date unit =" + text, 0);
        }
    }

    public DateType(String text, String format, String type, ucar.nc2.time.Calendar cal2) throws ParseException {
        String calName;
        if (cal2 == null) {
            cal2 = ucar.nc2.time.Calendar.getDefault();
        }
        this.text = text = text == null ? "" : text.trim();
        this.format = format;
        this.type = type;
        if (text.length() == 0) {
            this.isBlank = true;
            this.date = null;
            return;
        }
        this.isPresent = text.equalsIgnoreCase("present");
        if (this.isPresent) {
            this.date = null;
            return;
        }
        if (format != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            Calendar c = Calendar.getInstance();
            c.setTime(dateFormat.parse(text));
            this.date = CalendarDate.of(cal2, c.getTimeInMillis());
            return;
        }
        String string = calName = cal2 == null ? null : cal2.name();
        if (text.indexOf("since") > 0) {
            this.date = CalendarDate.parseUdunits(calName, text);
            if (this.date == null) {
                throw new ParseException("invalid udunit date unit =" + text, 0);
            }
            return;
        }
        this.date = CalendarDate.parseISOformat(calName, text);
        if (this.date == null) {
            throw new ParseException("invalid ISO date unit =" + text, 0);
        }
    }

    public Date getDate() {
        return this.isPresent() ? new Date() : this.date.toDate();
    }

    public CalendarDate getCalendarDate() {
        return this.isPresent() ? CalendarDate.present() : this.date;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isBlank() {
        return this.isBlank;
    }

    public String getText() {
        if (this.isPresent) {
            this.text = "present";
        }
        if (this.text == null) {
            this.text = this.toDateTimeString();
        }
        return this.text;
    }

    public String getFormat() {
        return this.format;
    }

    public String getType() {
        return this.type;
    }

    public DateType setType(String type) {
        this.type = type;
        return this;
    }

    public boolean before(Date d) {
        if (this.isPresent()) {
            return false;
        }
        return this.date.isBefore(CalendarDate.of(d));
    }

    public boolean before(DateType d) {
        if (d.isPresent()) {
            return true;
        }
        if (this.isPresent()) {
            return false;
        }
        return this.date.isBefore(d.getCalendarDate());
    }

    public boolean after(Date d) {
        if (this.isPresent()) {
            return true;
        }
        return this.date.isAfter(CalendarDate.of(d));
    }

    public String toDateString() {
        if (this.isPresent()) {
            return CalendarDateFormatter.toDateStringPresent();
        }
        return CalendarDateFormatter.toDateString(this.date);
    }

    public String toDateTimeString() {
        if (this.isPresent()) {
            return CalendarDateFormatter.toDateTimeStringISO(new Date());
        }
        return CalendarDateFormatter.toDateTimeStringISO(this.date);
    }

    public String toDateTimeStringISO() {
        return this.toDateTimeString();
    }

    public String toString() {
        return this.getText();
    }

    public int hashCode() {
        if (this.isBlank()) {
            return 0;
        }
        if (this.isPresent()) {
            return 1;
        }
        return this.getDate().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateType)) {
            return false;
        }
        DateType oo = (DateType)o;
        if (this.isPresent() && oo.isPresent()) {
            return true;
        }
        if (this.isBlank() && oo.isBlank()) {
            return true;
        }
        return oo.getDate().equals(this.getDate());
    }

    public DateType add(TimeDuration d) {
        return this.add(d.getTimeUnit());
    }

    public DateType add(TimeUnit d) {
        CalendarDate useDate = this.getCalendarDate();
        CalendarDate result = useDate.add((int)d.getValueInSeconds(), CalendarPeriod.Field.Second);
        return new DateType(result);
    }

    public DateType subtract(TimeDuration d) {
        return this.subtract(d.getTimeUnit());
    }

    public DateType subtract(TimeUnit d) {
        CalendarDate useDate = this.getCalendarDate();
        CalendarDate result = useDate.add((int)(-d.getValueInSeconds()), CalendarPeriod.Field.Second);
        return new DateType(result);
    }

    private static void doOne(String s) {
        try {
            System.out.println("\nString = (" + s + ")");
            DateType d = new DateType(s, null, null);
            System.out.println("DateType = (" + d.toString() + ")");
            System.out.println("Date = (" + d.getDate() + ")");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        DateType.doOne("T00:00:00Z");
    }
}

