/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.plugin;

import java.util.Hashtable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Consumer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.dataanalysis.executor.plugin.QueueListener;
import org.gcube.dataanalysis.executor.plugin.QueueWatcher;
import org.gcube.dataanalysis.executor.plugin.ScriptIOWorker;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class GenericWorkerPlugin
extends GCUBEHandler<TaskRuntime>
implements ExecutorTask {
    public static Consumer activeT;
    public static QueueWatcher qWatcher;
    public static Hashtable<String, String> sessionBlackList;
    public static Boolean processing;
    public static Boolean creating;
    public static ConsumerWatcher2 consumerwatcher;
    public static Timer consumerWatcherTimer;
    static GCUBELog workerLogger;

    public void stop() throws UnsupportedOperationException, Exception {
        this.getLogger().trace((Object)"GenericWorkerPlugin: Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        if (workerLogger == null) {
            workerLogger = this.getLogger();
        }
        this.setState((State)State.Running.INSTANCE);
        this.getLogger().trace((Object)"GenericWorkerPlugin: Start");
        TaskRuntime runtime = (TaskRuntime)this.getHandled();
        String nodeAddress = GHNContext.getContext().getHostname();
        Map inputs = runtime.getInputs();
        this.getLogger().trace((Object)("GenericWorkerPlugin: Inputs: " + inputs + " on node: " + nodeAddress));
        try {
            String uniqueTopicName = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.TOPIC_NAME.name()));
            String user = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_USER.name()));
            String password = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_PASSWORD.name()));
            String queueURL = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QUEUE_URL.name()));
            String topicResponseName = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.TOPIC_RESPONSE_NAME.name()));
            String session = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.QSESSION.name()));
            String erase = ScriptIOWorker.getString((String)inputs.get(ATTRIBUTE.ERASE.name()));
            if (consumerwatcher == null || consumerWatcherTimer == null) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: Starting consumer watcher");
                consumerWatcherTimer = new Timer();
                consumerwatcher = new ConsumerWatcher2();
                consumerWatcherTimer.schedule((TimerTask)consumerwatcher, QCONSTANTS.QueueLifeTime, (long)QCONSTANTS.QueueLifeTime);
            }
            if (session == null) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: Session is null ignoring message");
            } else if (sessionBlackList != null && sessionBlackList.contains(session)) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: Session is black listed ... ignoring message");
            } else if (GenericWorkerPlugin.getProcessing()) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: The worker is processing... ignoring message");
            } else if (GenericWorkerPlugin.getCreating()) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: The worker is creating... ignoring message");
            } else if (erase != null && erase.equals("true")) {
                this.getLogger().trace((Object)"GenericWorkerPlugin: Erasing queue command");
                this.getLogger().trace((Object)("GenericWorkerPlugin: purging session " + session + " on queue " + uniqueTopicName));
                sessionBlackList.put(session, uniqueTopicName);
                this.getLogger().trace((Object)("GenericWorkerPlugin: topic " + session + "on queue " + uniqueTopicName + " has been blacklisted"));
            } else {
                this.getLogger().trace((Object)"GenericWorkerPlugin: The worker is available");
                GenericWorkerPlugin.setCreating(true);
                boolean eraseCon = GenericWorkerPlugin.eraseConsumer();
                if (eraseCon) {
                    this.createConsumer(uniqueTopicName, session, user, password, queueURL, nodeAddress);
                } else {
                    this.getLogger().trace((Object)"GenericWorkerPlugin: could not erase che consumer ... ignoring message");
                }
                GenericWorkerPlugin.setCreating(false);
            }
            this.setState((State)State.Done.INSTANCE);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getLogger().error((Object)("GenericWorkerPlugin: Error " + e.getLocalizedMessage()));
            this.getLogger().trace((Object)"GenericWorkerPlugin: Completely Finished");
            this.setState((State)State.Failed.INSTANCE);
        }
        finally {
            this.stop();
        }
    }

    public static void setProcessing(boolean state) {
        processing = state;
    }

    public static boolean getProcessing() {
        if (processing == null) {
            processing = false;
        }
        return processing;
    }

    public static boolean getCreating() {
        if (creating == null) {
            creating = false;
        }
        return creating;
    }

    public static void setCreating(boolean state) {
        creating = state;
    }

    public static boolean eraseConsumer() {
        try {
            if (activeT != null) {
                workerLogger.trace((Object)"GenericWorkerPlugin: deleting the previous consumer");
                activeT.stop();
                activeT.closeSession();
                activeT = null;
                System.gc();
                Thread.sleep(2000L);
            }
            workerLogger.trace((Object)"GenericWorkerPlugin: Previous consumer is offline!");
        }
        catch (Throwable e) {
            workerLogger.trace((Object)("GenericWorkerPlugin: Error could not erase Consumer! " + e.getLocalizedMessage()));
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void createConsumer(String uniqueTopicName, String session, String user, String password, String queueURL, String nodeAddress) {
        try {
            this.getLogger().trace((Object)("GenericWorkerPlugin: Adding Topic " + uniqueTopicName + " with session " + session));
            this.getLogger().trace((Object)"GenericWorkerPlugin: Active Queue is null - creating");
            this.getLogger().trace((Object)"GenericWorkerPlugin: Creating Consumer");
            QueueManager qm = new QueueManager();
            qm.createAndConnect(user, password, queueURL, uniqueTopicName);
            QueueListener ql = new QueueListener(qm, uniqueTopicName, nodeAddress, this.logger);
            activeT = new Consumer(qm, ql, ql, uniqueTopicName);
            this.getLogger().trace((Object)"GenericWorkerPlugin: Active Queue Consumer was created!");
            this.getLogger().trace((Object)"GenericWorkerPlugin: Creation was set to FALSE");
        }
        catch (Throwable e) {
            this.getLogger().trace((Object)("GenericWorkerPlugin: Error could not create Consumer! " + e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    public static void resetGenericWorker() {
        GenericWorkerPlugin.setCreating(true);
        GenericWorkerPlugin.eraseConsumer();
        if (sessionBlackList != null && sessionBlackList.size() > 10) {
            sessionBlackList = null;
            sessionBlackList = new Hashtable();
            workerLogger.trace((Object)"GenericWorkerPlugin: Refreshing the black list!");
        }
        GenericWorkerPlugin.setCreating(false);
        GenericWorkerPlugin.purgeConsumerWatcher();
        System.gc();
        workerLogger.trace((Object)"GenericWorkerPlugin: Reset GW!");
    }

    public static void purgeConsumerWatcher() {
        workerLogger.trace((Object)"GenericWorkerPlugin: Stopping - closing all watchers");
        if (consumerwatcher != null) {
            consumerwatcher.cancel();
            if (consumerWatcherTimer != null) {
                consumerWatcherTimer.cancel();
                consumerWatcherTimer.purge();
            }
            consumerwatcher = null;
            consumerWatcherTimer = null;
        }
        workerLogger.trace((Object)"GenericWorkerPlugin: Stopping - closed all watchers");
    }

    static {
        sessionBlackList = new Hashtable();
    }

    public class ConsumerWatcher2
    extends TimerTask {
        @Override
        public void run() {
            try {
                if (!GenericWorkerPlugin.getProcessing() && !GenericWorkerPlugin.getCreating()) {
                    GenericWorkerPlugin.resetGenericWorker();
                }
            }
            catch (Exception e) {
                System.out.println("GenericWorkerPlugin: ERROR IN RESETTING WATCHER!");
                e.printStackTrace();
            }
        }
    }
}

