/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Producer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.dataanalysis.executor.plugin.GenericWorkerPlugin;
import org.gcube.dataanalysis.executor.scripts.ExecuteScript;

public class QueueListener
implements MessageListener,
ExceptionListener {
    private String topicName;
    private GCUBELog logger;
    public static int refreshStatusTime = QCONSTANTS.refreshStatusTime;
    public QueueManager qm;
    public String nodeaddress;
    public static long timeToLive = 0L;

    public QueueListener(QueueManager qm, String topicName, String nodeaddress, GCUBELog logger) {
        this.topicName = topicName;
        this.logger = logger;
        this.qm = qm;
        this.nodeaddress = nodeaddress;
    }

    public synchronized void onException(JMSException ex) {
        try {
            this.logger.trace((Object)"GenericWorkerPlugin: AN ERROR OCCURRED ", (Throwable)ex);
        }
        catch (Exception e) {
            this.logger.trace((Object)"GenericWorkerPlugin: Exception", (Throwable)e);
        }
        this.logger.trace((Object)"GenericWorkerPlugin: JMS Exception occured.  Shutting down client.", (Throwable)ex);
        ex.printStackTrace();
    }

    private void sendStatus(Producer p, String order, String status, String session, Exception e) throws Exception {
        this.logger.trace((Object)("GenericWorkerPlugin: SENDING THE FOLLOWING : status " + status + " order " + order + " address " + this.nodeaddress + " session " + session));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(ATTRIBUTE.STATUS.name(), status);
        props.put(ATTRIBUTE.ORDER.name(), order);
        props.put(ATTRIBUTE.NODE.name(), this.nodeaddress);
        props.put(ATTRIBUTE.QSESSION.name(), session);
        if (e != null) {
            props.put(ATTRIBUTE.ERROR.name(), e.getLocalizedMessage());
        } else {
            props.put(ATTRIBUTE.ERROR.name(), null);
        }
        if (status != null && order != null && this.nodeaddress != null && p != null && session != null) {
            p.sendMessage(props, timeToLive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        String session = null;
        String order = null;
        Timer statusSenderScheduler = null;
        Producer producer = null;
        try {
            this.logger.trace((Object)("GenericWorkerPlugin:  Incoming message on queue " + this.topicName));
            if (!GenericWorkerPlugin.getProcessing()) {
                this.logger.trace((Object)"GenericWorkerPlugin:  Ack message ");
                message.acknowledge();
                this.logger.trace((Object)"GenericWorkerPlugin:  Set Processing to True");
                GenericWorkerPlugin.setProcessing(true);
                this.logger.trace((Object)("GenericWorkerPlugin: Received Message on queue " + this.topicName));
                this.logger.trace((Object)"GenericWorkerPlugin: ack message");
                HashMap inputs = (HashMap)message.getObjectProperty(ATTRIBUTE.CONTENT.name());
                this.logger.trace((Object)("GenericWorkerPlugin: Getting contents : " + inputs.size()));
                session = (String)inputs.get(ATTRIBUTE.QSESSION.name());
                if (session != null && GenericWorkerPlugin.sessionBlackList != null && !GenericWorkerPlugin.sessionBlackList.contains(session)) {
                    this.logger.trace((Object)("GenericWorkerPlugin: managing session: " + session));
                    List filenames = (List)inputs.get(ATTRIBUTE.FILE_NAMES.name());
                    List fileurls = (List)inputs.get(ATTRIBUTE.FILE_URLS.name());
                    String nodeConfigurationString = (String)inputs.get(ATTRIBUTE.CONFIGURATION.name());
                    String outputDir = (String)inputs.get(ATTRIBUTE.OUTPUTDIR.name());
                    String owner = (String)inputs.get(ATTRIBUTE.OWNER.name());
                    String remoteDir = (String)inputs.get(ATTRIBUTE.REMOTEDIR.name());
                    String serviceClass = (String)inputs.get(ATTRIBUTE.SERVICE_CLASS.name());
                    String serviceName = (String)inputs.get(ATTRIBUTE.SERVICE_NAME.name());
                    String scope = (String)inputs.get(ATTRIBUTE.SCOPE.name());
                    String script = (String)inputs.get(ATTRIBUTE.SCRIPT.name());
                    String arguments = (String)inputs.get(ATTRIBUTE.ARGUMENTS.name());
                    String delFiles = (String)inputs.get(ATTRIBUTE.CLEAN_CACHE.name());
                    String responseQueue = (String)inputs.get(ATTRIBUTE.TOPIC_RESPONSE_NAME.name());
                    String quser = (String)inputs.get(ATTRIBUTE.QUEUE_USER.name());
                    String qpwd = (String)inputs.get(ATTRIBUTE.QUEUE_PASSWORD.name());
                    String qurl = (String)inputs.get(ATTRIBUTE.QUEUE_URL.name());
                    boolean deletefiles = delFiles == null ? true : Boolean.parseBoolean(delFiles);
                    ExecuteScript scripter = new ExecuteScript(this.logger);
                    this.logger.trace((Object)"GenericWorkerPlugin: Building producer...");
                    QueueManager qmR = new QueueManager();
                    qmR.createAndConnect(quser, qpwd, qurl, responseQueue);
                    producer = new Producer(qmR, responseQueue);
                    this.logger.trace((Object)"GenericWorkerPlugin: ...Producer built");
                    order = "" + inputs.get(ATTRIBUTE.ORDER.name());
                    this.sendStatus(producer, order, ATTRIBUTE.STARTED.name(), session, null);
                    statusSenderScheduler = new Timer();
                    statusSenderScheduler.schedule((TimerTask)new StatusSender(order, session, producer), 0L, (long)refreshStatusTime);
                    this.logger.trace((Object)"GenericWorkerPlugin: Executing Script");
                    scripter.executeScript(filenames, fileurls, outputDir, script, arguments, order, scope, serviceClass, serviceName, owner, remoteDir, session, nodeConfigurationString, deletefiles);
                    this.logger.trace((Object)"GenericWorkerPlugin: Sending Back Message");
                    this.purgeStatusScheduler(statusSenderScheduler);
                    this.sendStatus(producer, order, ATTRIBUTE.FINISHED.name(), session, null);
                    this.logger.trace((Object)"GenericWorkerPlugin: message correctly processed");
                } else {
                    this.logger.trace((Object)("GenericWorkerPlugin: ignoring message with session " + session));
                }
            } else {
                this.logger.trace((Object)("GenericWorkerPlugin: Processing .. discarding message on queue " + this.topicName));
                Thread.sleep(2000L);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"GenericWorkerPlugin: An Error occurred - Fatal error reporting ");
            try {
                this.sendStatus(producer, order, ATTRIBUTE.FATAL_ERROR.name(), session, ex);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                this.logger.error((Object)"GenericWorkerPlugin: Error in sending fault message: ", (Throwable)e2);
            }
            ex.printStackTrace();
            this.logger.error((Object)"GenericWorkerPlugin: Error in message: ", (Throwable)ex);
        }
        finally {
            this.purgeStatusScheduler(statusSenderScheduler);
            this.purgeProducer(producer);
            GenericWorkerPlugin.setProcessing(false);
        }
    }

    private void purgeProducer(Producer producer) {
        if (producer != null) {
            try {
                this.logger.debug((Object)"GenericWorkerPlugin: Stopping producer");
                producer.stop();
                this.logger.debug((Object)"GenericWorkerPlugin: Producer Stopped");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Object)"GenericWorkerPlugin: Error in stopping producer: ", (Throwable)e);
            }
        }
    }

    private void purgeStatusScheduler(Timer statusSenderScheduler) {
        try {
            if (statusSenderScheduler != null) {
                this.logger.debug((Object)"GenericWorkerPlugin: purging timer task ");
                statusSenderScheduler.cancel();
                statusSenderScheduler.purge();
                statusSenderScheduler = null;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"GenericWorkerPlugin: Error purging timer task!!!");
            e.printStackTrace();
        }
    }

    private class StatusSender
    extends TimerTask {
        String session;
        String order;
        Producer producer;

        public StatusSender(String order, String session, Producer p) {
            this.session = session;
            this.order = order;
            this.producer = p;
        }

        @Override
        public void run() {
            try {
                QueueListener.this.sendStatus(this.producer, this.order, ATTRIBUTE.PROCESSING.name(), this.session, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                QueueListener.this.logger.trace((Object)"GenericWorkerPlugin: Error Sending Status message");
            }
        }
    }
}

