/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.environment.thredds;

import java.awt.geom.Point2D;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NoDatasetFiles {
    private String filename;
    private String mode;
    private Point2D.Double[] points;
    private NetcdfFile ncFile;
    private Variable var;
    public static final int GRID_COLS = 43200;
    public static final int GRID_ROWS = 21600;

    public NoDatasetFiles(String filename) {
        this.filename = filename;
    }

    public void open() throws IOException {
        this.ncFile = NetcdfDataset.openFile((String)this.filename, null);
        this.var = this.ncFile.findVariable("z");
    }

    public void close() throws IOException {
        if (this.ncFile != null) {
            this.ncFile.close();
        }
    }

    public short getZ(Point2D.Double point) throws IOException {
        return this.getZ(point.getX(), point.getY());
    }

    public short[] getZ(Point2D.Double[] points) throws IOException {
        short[] result = new short[points.length];
        int i = 0;
        while (i < points.length) {
            result[i] = this.getZ(points[i].getX(), points[i].getY());
            ++i;
        }
        return result;
    }

    public short getZ(double x, double y) throws NullPointerException, IOException {
        int gridRow;
        int gridCol;
        int resultInt = 0;
        if (this.ncFile == null) {
            throw new NullPointerException("No netCDF file not open");
        }
        if (this.var == null) {
            throw new NullPointerException("Variable 'z' not found");
        }
        double gridColD = (x + 180.0) * 120.0;
        boolean averageWithNextCol = false;
        boolean averageWithNextRow = false;
        if (gridColD < 0.0 || gridColD >= 43200.0) {
            gridCol = 43199;
            averageWithNextCol = true;
        } else {
            gridCol = (int)Math.floor(gridColD);
            if (gridColD - (double)gridCol < 0.1) {
                gridCol = (gridCol + 43200 - 1) % 43200;
                averageWithNextCol = true;
            } else if (gridColD - (double)gridCol > 0.9) {
                averageWithNextCol = true;
            }
        }
        double gridRowD = (90.0 - y) * 120.0;
        if (gridRowD < 0.0) {
            gridRow = 0;
        } else if (gridRowD >= 21600.0) {
            gridRow = 21599;
        } else {
            gridRow = (int)Math.floor(gridRowD);
            if (gridRowD - (double)gridRow < 0.1 && gridRow > 0) {
                --gridRow;
                averageWithNextRow = true;
            } else if (gridRowD - (double)gridRow > 0.9 && gridRow < 21599) {
                averageWithNextRow = true;
            }
        }
        int[] shape = new int[]{averageWithNextCol ? 2 : 1};
        int[] origin = new int[]{43200 * gridRow + gridCol};
        short result = 0;
        try {
            Array arr = this.var.read(origin, shape);
            resultInt = arr.getShort(0);
            if (averageWithNextCol) {
                resultInt += arr.getShort(1);
            }
            if (averageWithNextRow) {
                origin[0] = origin[0] + 43200;
                arr = this.var.read(origin, shape);
                resultInt += arr.getShort(0);
                if (averageWithNextCol) {
                    resultInt += arr.getShort(1);
                }
            }
            result = (short)(resultInt / ((averageWithNextCol ? 2 : 1) * (averageWithNextRow ? 2 : 1)));
        }
        catch (InvalidRangeException e1) {
            e1.printStackTrace();
        }
        return result;
    }

    public static double getVarPoint(Variable var, double x, double y) throws NullPointerException, IOException {
        int gridRow;
        int gridCol;
        double resultInt = 0.0;
        double gridColD = (x + 180.0) * 120.0;
        double gridRowD = (90.0 - y) * 120.0;
        boolean averageWithNextCol = false;
        boolean averageWithNextRow = false;
        if (gridColD < 0.0 || gridColD >= 43200.0) {
            gridCol = 43199;
            averageWithNextCol = true;
        } else {
            gridCol = (int)Math.floor(gridColD);
            if (gridColD - (double)gridCol < 0.1) {
                gridCol = (gridCol + 43200 - 1) % 43200;
                averageWithNextCol = true;
            } else if (gridColD - (double)gridCol > 0.9) {
                averageWithNextCol = true;
            }
        }
        if (gridRowD < 0.0) {
            gridRow = 0;
        } else if (gridRowD >= 21600.0) {
            gridRow = 21599;
        } else {
            gridRow = (int)Math.floor(gridRowD);
            if (gridRowD - (double)gridRow < 0.1 && gridRow > 0) {
                --gridRow;
                averageWithNextRow = true;
            } else if (gridRowD - (double)gridRow > 0.9 && gridRow < 21599) {
                averageWithNextRow = true;
            }
        }
        int[] shape = new int[]{averageWithNextCol ? 2 : 1};
        int[] origin = new int[]{43200 * gridRow + gridCol};
        double result = 0.0;
        try {
            Array arr = var.read();
            resultInt = arr.getDouble(0);
            if (averageWithNextCol) {
                resultInt += arr.getDouble(1);
            }
            if (averageWithNextRow) {
                origin[0] = origin[0] + 43200;
                arr = var.read(origin, shape);
                resultInt += arr.getDouble(0);
                if (averageWithNextCol) {
                    resultInt += arr.getDouble(1);
                }
            }
            result = resultInt / (double)((averageWithNextCol ? 2 : 1) * (averageWithNextRow ? 2 : 1));
        }
        catch (InvalidRangeException e1) {
            e1.printStackTrace();
        }
        return result;
    }
}

