/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.environment.thredds;

import java.util.List;
import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeonetworkCaller;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.dataanalysis.environment.thredds.ThreddsDataExplorer;
import org.gcube.dataanalysis.environment.utils.ELog;
import org.gcube.dataanalysis.environment.utils.MetadataInsertionGeonetwork;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;

public class ThreddsMetadataInserter {
    public static String Separator = " ";

    public static void addGridDatasetToGeoNetwork(String fileurl, String filename, String geonetworkUrl, String geonetworkUsername, String geonetworkPassword, String geoserverUsername, String geoserverPassword) throws Exception {
        GridDataset gds = GridDataset.open((String)fileurl);
        List gridTypes = gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            GridCoordSystem gcs = grid.getCoordinateSystem();
            String officialDescription = ThreddsMetadataInserter.treatDescription(gdt.getDescription()).trim();
            if (officialDescription.length() <= 0) continue;
            String unit = gdt.getUnitsString().trim();
            if (unit.length() > 0 && !unit.startsWith("(")) {
                unit = "(" + unit + ")";
            }
            ELog.debug("ThreddsDataExplorer-> ADDING TO GEONET: " + officialDescription);
            CoordinateAxis xAxis = gcs.getXHorizAxis();
            CoordinateAxis yAxis = gcs.getYHorizAxis();
            double x1 = xAxis.getMinValue() - 180.0;
            double x2 = xAxis.getMaxValue() - 180.0;
            double y1 = yAxis.getMinValue();
            double y2 = yAxis.getMaxValue();
            if (x1 < -180.0) {
                x1 = -180.0;
            }
            if (x1 > 180.0) {
                x1 = 180.0;
            }
            if (x2 > 180.0) {
                x2 = 180.0;
            }
            if (x2 < -180.0) {
                x2 = -180.0;
            }
            if (y1 < -90.0) {
                y1 = -90.0;
            }
            if (y1 > 90.0) {
                y1 = 90.0;
            }
            if (y2 > 90.0) {
                y2 = 90.0;
            }
            if (y2 < -90.0) {
                y2 = -90.0;
            }
            ELog.debug("ThreddsDataExplorer-> Bounding Box: (" + x1 + "," + x2 + "," + y1 + "," + y2 + ")");
            MetadataInsertionGeonetwork.addThreddsMetadata(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword, officialDescription + Separator + ThreddsMetadataInserter.treatFileName(filename), filename + ":" + gdt.getFullName().trim(), gdt.getFullName().trim() + ": " + officialDescription + " " + unit + " from " + ThreddsMetadataInserter.treatFileName(filename), fileurl, xAxis.getMinValue() - 180.0, xAxis.getMaxValue() - 180.0, yAxis.getMinValue(), yAxis.getMaxValue());
        }
    }

    public static void updateGeonetwork(String threddsCatalogUrl, String geonetworkUrl, String geonetworkUsername, String geoserverUsername, String geoserverPassword, String geonetworkPassword) throws Exception {
        List<String> files = ThreddsDataExplorer.getFiles(threddsCatalogUrl);
        String threddsprefix = threddsCatalogUrl.substring(0, threddsCatalogUrl.lastIndexOf("/")).replace("/catalog/", "/dodsC/");
        for (String file : files) {
            String threddsFile = threddsprefix + "/" + file;
            ELog.debug("ThreddsDataExplorer-> FILE " + threddsFile);
            if (!ThreddsDataExplorer.isGridDataset(threddsFile)) continue;
            if (!ThreddsMetadataInserter.isFileOnGeoNetwork(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword, file)) {
                ThreddsMetadataInserter.addGridDatasetToGeoNetwork(threddsFile, file, geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword);
                continue;
            }
            ELog.debug("ThreddsDataExplorer-> YET PRESENT");
        }
    }

    public static boolean isFileOnGeoNetwork(String geonetworkUrl, String geonetworkUsername, String geonetworkPassword, String geoserverUsername, String geoserverPassword, String filename) {
        GeonetworkCaller geonetworkCaller = new GeonetworkCaller(geonetworkUrl, geonetworkUsername, geonetworkPassword, geoserverUsername, geoserverPassword);
        LayerCsw layer = null;
        try {
            layer = geonetworkCaller.getLayersInformation(GeoCaller.FILTER_TYPE.ANY_TEXT, ThreddsMetadataInserter.treatFileName(filename));
        }
        catch (Exception e) {
            ELog.debug("WARNING: Error in retrieving filename " + filename + " from GeoNewtork -> " + e.getLocalizedMessage());
        }
        return layer != null;
    }

    public static String treatFileName(String file) {
        return file.replace("_", "").replace("-", "");
    }

    public static String treatDescription(String description) {
        description = description.toLowerCase();
        return description.replace("_", " ").replace("-", " ").replaceAll("[^A-Za-z0-9 ]", "");
    }

    public static String treatLayerTitle(String name) {
        if (name.toLowerCase().endsWith(".nc")) {
            return name.substring(name.lastIndexOf(" ")).trim();
        }
        return name;
    }

    public static String treatLayerTitleForSearch(String name) {
        String name1 = ThreddsMetadataInserter.treatLayerTitle(name);
        return name1;
    }

    public static void main(String[] args) throws Exception {
        String threddsCatalogUrl = "http://thredds.research-infrastructures.eu:8080/thredds/catalog/public/netcdf/catalog.xml";
        String geonetworkUrl = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geonetwork";
        String geonetworkUsername = "admin";
        String geonetworkPassword = "admin";
        String geoServerUser = "admin";
        String geoServerPassword = "gCube@geo2010";
        long t0 = System.currentTimeMillis();
        ThreddsMetadataInserter.updateGeonetwork(threddsCatalogUrl, geonetworkUrl, geonetworkUsername, geonetworkPassword, geoServerUser, geoServerPassword);
        ELog.debug("ThreddsDataExplorer-> Elapsed: " + (System.currentTimeMillis() - t0));
    }
}

