/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.util.Arrays;

public class ColorMap {
    public int size;
    public byte[] r;
    public byte[] g;
    public byte[] b;
    public Color[] table;

    public static ColorMap getJet() {
        return ColorMap.getJet(64);
    }

    public static ColorMap getJet(int n) {
        byte[] r = new byte[n];
        byte[] g = new byte[n];
        byte[] b = new byte[n];
        int maxval = 255;
        Arrays.fill(g, 0, n / 8, (byte)0);
        int x = 0;
        while (x < n / 4) {
            g[x + n / 8] = (byte)(maxval * x * 4 / n);
            ++x;
        }
        Arrays.fill(g, n * 3 / 8, n * 5 / 8, (byte)maxval);
        x = 0;
        while (x < n / 4) {
            g[x + n * 5 / 8] = (byte)(maxval - maxval * x * 4 / n);
            ++x;
        }
        Arrays.fill(g, n * 7 / 8, n, (byte)0);
        x = 0;
        while (x < g.length) {
            b[x] = g[(x + n / 4) % g.length];
            ++x;
        }
        Arrays.fill(b, n * 7 / 8, n, (byte)0);
        Arrays.fill(g, 0, n / 8, (byte)0);
        x = n / 8;
        while (x < g.length) {
            r[x] = g[(x + n * 6 / 8) % g.length];
            ++x;
        }
        ColorMap cm = new ColorMap();
        cm.size = n;
        cm.r = r;
        cm.g = g;
        cm.b = b;
        cm.table = new Color[n];
        int x2 = 0;
        while (x2 < n) {
            cm.table[x2] = new Color(cm.getColor(x2));
            ++x2;
        }
        return cm;
    }

    public int getColor(int idx) {
        int pixel = this.r[idx] << 16 & 0xFF0000 | this.g[idx] << 8 & 0xFF00 | this.b[idx] & 0xFF;
        return pixel;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(500);
        int x = 0;
        while (x < this.size) {
            s.append(String.valueOf(x) + ": {" + this.r[x] + ",\t" + this.g[x] + ",\t" + this.b[x] + "}\t");
            if (x % 3 == 2) {
                s.append("\n");
            }
            ++x;
        }
        return s.toString();
    }

    public static void main(String[] args) {
        ColorMap jet = ColorMap.getJet();
        ColorMap jet128 = ColorMap.getJet(128);
        System.out.println("Jet:\n" + jet + "\n\nJet128:\n" + jet128);
    }
}

