/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.timeseries.charts.support.tablemodel;

import java.io.Serializable;
import org.gcube.portlets.user.timeseries.charts.support.assertions.Assertion;
import org.gcube.portlets.user.timeseries.charts.support.exceptions.InvalidParameterException;
import org.gcube.portlets.user.timeseries.charts.support.tablemodel.FieldType;

public final class FieldDescr
implements Serializable {
    private static final long serialVersionUID = 532149221570962514L;
    private String alias = null;
    private String rawname = null;

    private FieldDescr() {
    }

    public FieldDescr(String rawname) throws InvalidParameterException {
        this(null, rawname, FieldType.ND);
    }

    public FieldDescr(String rawname, FieldType type) throws InvalidParameterException {
        this(null, rawname, type);
    }

    public FieldDescr(String alias, String rawname) throws InvalidParameterException {
        this(alias, rawname, FieldType.ND);
        this.setAlias(alias);
        this.setRawName(rawname);
    }

    public FieldDescr(String alias, String rawname, FieldType type) throws InvalidParameterException {
        this();
        this.setAlias(alias);
        this.setRawName(rawname);
    }

    public void setAlias(String alias) {
        if (alias != null && alias.trim().length() > 0) {
            this.alias = alias.trim();
        }
    }

    public void setRawName(String rawName) throws InvalidParameterException {
        Assertion<InvalidParameterException> checker = new Assertion<InvalidParameterException>();
        checker.validate(rawName != null && rawName.trim().length() > 0, new InvalidParameterException("The raw name cannot be null or empty."));
        this.rawname = rawName.trim();
    }

    public String getRawName() {
        return this.rawname;
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.rawname;
    }
}

