/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.data;

import java.util.HashMap;
import org.gcube.contentmanagement.graphtools.abstracts.SamplesTable;
import org.gcube.contentmanagement.graphtools.data.BigSparseTable;

public class BigSamplesTable
extends SamplesTable {
    BigSparseTable table = new BigSparseTable();
    HashMap<Integer, String> classifications = new HashMap();
    Integer currentIndex = 0;

    @Override
    public int getNumOfAttributes() {
        return this.table.width();
    }

    @Override
    public int getNumOfDataRows() {
        return this.table.size();
    }

    @Override
    public double getValue(int d, int a) {
        return this.table.get(d, a);
    }

    @Override
    public String getClassification(int d) {
        return this.classifications.get(d);
    }

    @Override
    public void addSampleRow(String label, double ... values) {
        this.classifications.put(this.currentIndex, label);
        int j = 0;
        double[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Double value = arr$[i$];
            this.table.add(this.currentIndex, j, value);
            ++j;
        }
        this.currentIndex = this.currentIndex + 1;
    }

    @Override
    public void addSample(int i, int j, double value) {
        if (i < this.currentIndex) {
            this.table.add(i, j, value);
        }
    }

    @Override
    public void addLabel(int i, String label) {
        if (i < this.currentIndex) {
            this.classifications.put(i, label);
        }
    }

    public static void main(String[] args) {
        BigSamplesTable bst = new BigSamplesTable();
        bst.addSampleRow("prova 1", 10.0, 12.0, 13.0, 14.0, 15.0);
        bst.addSampleRow("prova 2", 20.0, 15.0, 14.0, 15.0);
        bst.addSampleRow("prova 3", 30.0, 11.0, 110.0, 150.0);
        bst.addSample(0, -1, 150.0);
        System.out.println(bst.toString());
        bst.generateExampleSet();
    }
}

