/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation.bioclimate;

import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class BioClimateGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;
    double max;
    double min;

    public BioClimateGraph(String title, double max, double min) {
        super(title);
        this.max = max;
        this.min = min;
    }

    @Override
    protected Dataset generateDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String type1 = "Type 1";
        String type2 = "Type 2";
        String type3 = "Type 3";
        String type4 = "Type 4";
        String type5 = "Type 5";
        String type6 = "Type 6";
        String type7 = "Type 7";
        String type8 = "Type 8";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)series1), (Comparable)((Object)type1));
        dataset.addValue(4.0, (Comparable)((Object)series1), (Comparable)((Object)type2));
        dataset.addValue(3.0, (Comparable)((Object)series1), (Comparable)((Object)type3));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type4));
        dataset.addValue(5.0, (Comparable)((Object)series1), (Comparable)((Object)type5));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type6));
        dataset.addValue(7.0, (Comparable)((Object)series1), (Comparable)((Object)type7));
        dataset.addValue(8.0, (Comparable)((Object)series1), (Comparable)((Object)type8));
        dataset.addValue(5.0, (Comparable)((Object)series2), (Comparable)((Object)type1));
        dataset.addValue(7.0, (Comparable)((Object)series2), (Comparable)((Object)type2));
        dataset.addValue(6.0, (Comparable)((Object)series2), (Comparable)((Object)type3));
        dataset.addValue(8.0, (Comparable)((Object)series2), (Comparable)((Object)type4));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type5));
        dataset.addValue(4.0, (Comparable)((Object)series2), (Comparable)((Object)type6));
        dataset.addValue(2.0, (Comparable)((Object)series2), (Comparable)((Object)type7));
        dataset.addValue(1.0, (Comparable)((Object)series2), (Comparable)((Object)type8));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)type1));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type2));
        dataset.addValue(2.0, (Comparable)((Object)series3), (Comparable)((Object)type3));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type4));
        dataset.addValue(6.0, (Comparable)((Object)series3), (Comparable)((Object)type5));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type6));
        dataset.addValue(4.0, (Comparable)((Object)series3), (Comparable)((Object)type7));
        dataset.addValue(3.0, (Comparable)((Object)series3), (Comparable)((Object)type8));
        return dataset;
    }

    public static Image renderStaticImgObject(int width, int height, Dataset set, String title, double max, double min) {
        JFreeChart chart = BioClimateGraph.createStaticChart(set, max, min, title);
        Image image = ImageTools.toImage(chart.createBufferedImage(width, height));
        return image;
    }

    protected static JFreeChart createStaticChart(Dataset dataset, double max, double min, String title) {
        JFreeChart chart = ChartFactory.createLineChart((String)title, (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setRenderer((CategoryItemRenderer)new LineAndShapeRenderer(true, true));
        CategoryAxis categoryaxis1 = plot.getDomainAxis(0);
        categoryaxis1.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        plot.mapDatasetToDomainAxis(0, 0);
        if (max != min) {
            plot.getRangeAxis().setAutoRange(false);
            plot.getRangeAxis().setUpperBound(max);
            plot.getRangeAxis().setLowerBound(min);
            double avg = min + (max - min) / 2.0;
            plot.getRangeAxis().centerRange(avg);
        }
        return chart;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        JFreeChart chart = ChartFactory.createLineChart((String)this.getTitle(), (String)"", (String)"", (CategoryDataset)((DefaultCategoryDataset)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeCrosshairVisible(true);
        plot.setRenderer((CategoryItemRenderer)new LineAndShapeRenderer(true, true));
        CategoryAxis categoryaxis1 = plot.getDomainAxis(0);
        categoryaxis1.setCategoryLabelPositions(CategoryLabelPositions.DOWN_45);
        plot.mapDatasetToDomainAxis(0, 0);
        if (this.max != this.min) {
            plot.getRangeAxis().setAutoRange(false);
            plot.getRangeAxis().setUpperBound(this.max);
            plot.getRangeAxis().setLowerBound(this.min);
            double avg = this.min + (this.max - this.min) / 2.0;
            plot.getRangeAxis().centerRange(avg);
        }
        return chart;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new BioClimateGraph(title, this.max, this.min);
    }
}

